package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class MetricIdentifierBuilder extends MetricIdentifierFluentImpl<MetricIdentifierBuilder> implements VisitableBuilder<MetricIdentifier,MetricIdentifierBuilder> {

    MetricIdentifierFluent<?> fluent;
    Boolean validationEnabled;

    public MetricIdentifierBuilder() {
        this(true);
    }

    public MetricIdentifierBuilder(Boolean validationEnabled) {
        this(new MetricIdentifier(), validationEnabled);
    }

    public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent) {
        this(fluent, true);
    }

    public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new MetricIdentifier(), validationEnabled);
    }

    public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,MetricIdentifier instance) {
        this(fluent, instance, true);
    }

    public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent,MetricIdentifier instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withName(instance.getName()); 
        fluent.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public MetricIdentifierBuilder(MetricIdentifier instance) {
        this(instance,true);
    }

    public MetricIdentifierBuilder(MetricIdentifier instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withName(instance.getName()); 
        this.withSelector(instance.getSelector()); 
        this.validationEnabled = validationEnabled; 
    }

    public MetricIdentifier build() {
        MetricIdentifier buildable = new MetricIdentifier(fluent.getName(),fluent.getSelector());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        MetricIdentifierBuilder that = (MetricIdentifierBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
