package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface HorizontalPodAutoscalerListFluent<A extends HorizontalPodAutoscalerListFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public A addToItems(int index,HorizontalPodAutoscaler item);
    public A setToItems(int index,HorizontalPodAutoscaler item);
    public A addToItems(HorizontalPodAutoscaler... items);
    public A addAllToItems(Collection<HorizontalPodAutoscaler> items);
    public A removeFromItems(HorizontalPodAutoscaler... items);
    public A removeAllFromItems(Collection<HorizontalPodAutoscaler> items);
    public A removeMatchingFromItems(Predicate<HorizontalPodAutoscalerBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildItems instead.
 * @return The buildable object.
 */
@Deprecated public List<HorizontalPodAutoscaler> getItems();
    public List<HorizontalPodAutoscaler> buildItems();
    public HorizontalPodAutoscaler buildItem(int index);
    public HorizontalPodAutoscaler buildFirstItem();
    public HorizontalPodAutoscaler buildLastItem();
    public HorizontalPodAutoscaler buildMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate);
    public Boolean hasMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate);
    public A withItems(List<HorizontalPodAutoscaler> items);
    public A withItems(HorizontalPodAutoscaler... items);
    public Boolean hasItems();
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItem();
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItemLike(HorizontalPodAutoscaler item);
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> setNewItemLike(int index,HorizontalPodAutoscaler item);
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editItem(int index);
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editFirstItem();
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editLastItem();
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> editMatchingItem(Predicate<HorizontalPodAutoscalerBuilder> predicate);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public Boolean hasMetadata();
    public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HorizontalPodAutoscalerFluent<HorizontalPodAutoscalerListFluent.ItemsNested<N>> {

        public N and();
        public N endItem();    }


}
