package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class HorizontalPodAutoscalerBehaviorFluentImpl<A extends HorizontalPodAutoscalerBehaviorFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HorizontalPodAutoscalerBehaviorFluent<A> {

    private HPAScalingRulesBuilder scaleDown;
    private HPAScalingRulesBuilder scaleUp;

    public HorizontalPodAutoscalerBehaviorFluentImpl() { 
    }


    public HorizontalPodAutoscalerBehaviorFluentImpl(HorizontalPodAutoscalerBehavior instance) { 
        this.withScaleDown(instance.getScaleDown()); 
        this.withScaleUp(instance.getScaleUp()); 
    }


    
/**
 * This method has been deprecated, please use method buildScaleDown instead.
 * @return The buildable object.
 */
@Deprecated public HPAScalingRules getScaleDown() {
        return this.scaleDown!=null?this.scaleDown.build():null;
    }

    public HPAScalingRules buildScaleDown() {
        return this.scaleDown!=null?this.scaleDown.build():null;
    }

    public A withScaleDown(HPAScalingRules scaleDown) {
        _visitables.get("scaleDown").remove(this.scaleDown);
        if (scaleDown!=null){ this.scaleDown= new HPAScalingRulesBuilder(scaleDown); _visitables.get("scaleDown").add(this.scaleDown);} return (A) this;
    }

    public Boolean hasScaleDown() {
        return this.scaleDown != null;
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<A> withNewScaleDown() {
        return new ScaleDownNestedImpl();
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<A> withNewScaleDownLike(HPAScalingRules item) {
        return new ScaleDownNestedImpl(item);
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<A> editScaleDown() {
        return withNewScaleDownLike(getScaleDown());
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<A> editOrNewScaleDown() {
        return withNewScaleDownLike(getScaleDown() != null ? getScaleDown(): new HPAScalingRulesBuilder().build());
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<A> editOrNewScaleDownLike(HPAScalingRules item) {
        return withNewScaleDownLike(getScaleDown() != null ? getScaleDown(): item);
    }

    
/**
 * This method has been deprecated, please use method buildScaleUp instead.
 * @return The buildable object.
 */
@Deprecated public HPAScalingRules getScaleUp() {
        return this.scaleUp!=null?this.scaleUp.build():null;
    }

    public HPAScalingRules buildScaleUp() {
        return this.scaleUp!=null?this.scaleUp.build():null;
    }

    public A withScaleUp(HPAScalingRules scaleUp) {
        _visitables.get("scaleUp").remove(this.scaleUp);
        if (scaleUp!=null){ this.scaleUp= new HPAScalingRulesBuilder(scaleUp); _visitables.get("scaleUp").add(this.scaleUp);} return (A) this;
    }

    public Boolean hasScaleUp() {
        return this.scaleUp != null;
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<A> withNewScaleUp() {
        return new ScaleUpNestedImpl();
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<A> withNewScaleUpLike(HPAScalingRules item) {
        return new ScaleUpNestedImpl(item);
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<A> editScaleUp() {
        return withNewScaleUpLike(getScaleUp());
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<A> editOrNewScaleUp() {
        return withNewScaleUpLike(getScaleUp() != null ? getScaleUp(): new HPAScalingRulesBuilder().build());
    }

    public HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<A> editOrNewScaleUpLike(HPAScalingRules item) {
        return withNewScaleUpLike(getScaleUp() != null ? getScaleUp(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HorizontalPodAutoscalerBehaviorFluentImpl that = (HorizontalPodAutoscalerBehaviorFluentImpl) o;
        if (scaleDown != null ? !scaleDown.equals(that.scaleDown) :that.scaleDown != null) return false;
        if (scaleUp != null ? !scaleUp.equals(that.scaleUp) :that.scaleUp != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(scaleDown,  scaleUp,  super.hashCode());
    }

    public class ScaleDownNestedImpl<N> extends HPAScalingRulesFluentImpl<HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<N>> implements HorizontalPodAutoscalerBehaviorFluent.ScaleDownNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HPAScalingRulesBuilder builder;

        ScaleDownNestedImpl(HPAScalingRules item) {
            this.builder = new HPAScalingRulesBuilder(this, item);
        }

        ScaleDownNestedImpl() {
            this.builder = new HPAScalingRulesBuilder(this);
        }

        public N and() {
             return (N) HorizontalPodAutoscalerBehaviorFluentImpl.this.withScaleDown(builder.build());
        }

        public N endScaleDown() {
             return and();
        }
    }


    public class ScaleUpNestedImpl<N> extends HPAScalingRulesFluentImpl<HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<N>> implements HorizontalPodAutoscalerBehaviorFluent.ScaleUpNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HPAScalingRulesBuilder builder;

        ScaleUpNestedImpl(HPAScalingRules item) {
            this.builder = new HPAScalingRulesBuilder(this, item);
        }

        ScaleUpNestedImpl() {
            this.builder = new HPAScalingRulesBuilder(this);
        }

        public N and() {
             return (N) HorizontalPodAutoscalerBehaviorFluentImpl.this.withScaleUp(builder.build());
        }

        public N endScaleUp() {
             return and();
        }
    }


}
