package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface PodsMetricStatusFluent<A extends PodsMetricStatusFluent<A>> extends Fluent<A> {


    public Quantity getCurrentAverageValue();
    public A withCurrentAverageValue(Quantity currentAverageValue);
    public Boolean hasCurrentAverageValue();
    public A withNewCurrentAverageValue(String amount,String format);
    public A withNewCurrentAverageValue(String amount);
    public String getMetricName();
    public A withMetricName(String metricName);
    public Boolean hasMetricName();
    public A withNewMetricName(String arg1);
    public A withNewMetricName(StringBuilder arg1);
    public A withNewMetricName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public PodsMetricStatusFluent.SelectorNested<A> withNewSelector();
    public PodsMetricStatusFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PodsMetricStatusFluent.SelectorNested<A> editSelector();
    public PodsMetricStatusFluent.SelectorNested<A> editOrNewSelector();
    public PodsMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<PodsMetricStatusFluent.SelectorNested<N>> {

        public N and();
        public N endSelector();    }


}
