package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

public class HorizontalPodAutoscalerSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpecFluent<A> {

    private Integer maxReplicas;
    private List<MetricSpecBuilder> metrics =  new ArrayList<MetricSpecBuilder>();
    private Integer minReplicas;
    private io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder scaleTargetRef;

    public HorizontalPodAutoscalerSpecFluentImpl() { 
    }


    public HorizontalPodAutoscalerSpecFluentImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.HorizontalPodAutoscalerSpec instance) { 
        this.withMaxReplicas(instance.getMaxReplicas()); 
        this.withMetrics(instance.getMetrics()); 
        this.withMinReplicas(instance.getMinReplicas()); 
        this.withScaleTargetRef(instance.getScaleTargetRef()); 
    }


    public Integer getMaxReplicas() {
        return this.maxReplicas;
    }

    public A withMaxReplicas(Integer maxReplicas) {
        this.maxReplicas=maxReplicas; return (A) this;
    }

    public Boolean hasMaxReplicas() {
        return this.maxReplicas != null;
    }

    public A addToMetrics(int index,MetricSpec item) {
        if (this.metrics == null) {this.metrics = new ArrayList<MetricSpecBuilder>();}
        MetricSpecBuilder builder = new MetricSpecBuilder(item);_visitables.get("metrics").add(index >= 0 ? index : _visitables.get("metrics").size(), builder);this.metrics.add(index >= 0 ? index : metrics.size(), builder); return (A)this;
    }

    public A setToMetrics(int index,MetricSpec item) {
        if (this.metrics == null) {this.metrics = new ArrayList<MetricSpecBuilder>();}
        MetricSpecBuilder builder = new MetricSpecBuilder(item);
        if (index < 0 || index >= _visitables.get("metrics").size()) { _visitables.get("metrics").add(builder); } else { _visitables.get("metrics").set(index, builder);}
        if (index < 0 || index >= metrics.size()) { metrics.add(builder); } else { metrics.set(index, builder);}
         return (A)this;
    }

    public A addToMetrics(MetricSpec... items) {
        if (this.metrics == null) {this.metrics = new ArrayList<MetricSpecBuilder>();}
        for (MetricSpec item : items) {MetricSpecBuilder builder = new MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A addAllToMetrics(Collection<MetricSpec> items) {
        if (this.metrics == null) {this.metrics = new ArrayList<MetricSpecBuilder>();}
        for (MetricSpec item : items) {MetricSpecBuilder builder = new MetricSpecBuilder(item);_visitables.get("metrics").add(builder);this.metrics.add(builder);} return (A)this;
    }

    public A removeFromMetrics(MetricSpec... items) {
        for (MetricSpec item : items) {MetricSpecBuilder builder = new MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeAllFromMetrics(Collection<MetricSpec> items) {
        for (MetricSpec item : items) {MetricSpecBuilder builder = new MetricSpecBuilder(item);_visitables.get("metrics").remove(builder);if (this.metrics != null) {this.metrics.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromMetrics(Predicate<MetricSpecBuilder> predicate) {
        if (metrics == null) return (A) this;
        final Iterator<MetricSpecBuilder> each = metrics.iterator();
        final List visitables = _visitables.get("metrics");
        while (each.hasNext()) {
          MetricSpecBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildMetrics instead.
 * @return The buildable object.
 */
@Deprecated public List<MetricSpec> getMetrics() {
        return build(metrics);
    }

    public List<MetricSpec> buildMetrics() {
        return build(metrics);
    }

    public MetricSpec buildMetric(int index) {
        return this.metrics.get(index).build();
    }

    public MetricSpec buildFirstMetric() {
        return this.metrics.get(0).build();
    }

    public MetricSpec buildLastMetric() {
        return this.metrics.get(metrics.size() - 1).build();
    }

    public MetricSpec buildMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        for (MetricSpecBuilder item: metrics) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withMetrics(List<MetricSpec> metrics) {
        if (this.metrics != null) { _visitables.get("metrics").removeAll(this.metrics);}
        if (metrics != null) {this.metrics = new ArrayList<MetricSpecBuilder>(); for (MetricSpec item : metrics){this.addToMetrics(item);}} else { this.metrics = null;} return (A) this;
    }

    public A withMetrics(MetricSpec... metrics) {
        if (this.metrics != null) {this.metrics.clear();}
        if (metrics != null) {for (MetricSpec item :metrics){ this.addToMetrics(item);}} return (A) this;
    }

    public Boolean hasMetrics() {
        return metrics != null && !metrics.isEmpty();
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetric() {
        return new MetricsNestedImpl();
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> addNewMetricLike(MetricSpec item) {
        return new MetricsNestedImpl(-1, item);
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> setNewMetricLike(int index,MetricSpec item) {
        return new MetricsNestedImpl(index, item);
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMetric(int index) {
        if (metrics.size() <= index) throw new RuntimeException("Can't edit metrics. Index exceeds size.");
        return setNewMetricLike(index, buildMetric(index));
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editFirstMetric() {
        if (metrics.size() == 0) throw new RuntimeException("Can't edit first metrics. The list is empty.");
        return setNewMetricLike(0, buildMetric(0));
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editLastMetric() {
        int index = metrics.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last metrics. The list is empty.");
        return setNewMetricLike(index, buildMetric(index));
    }

    public HorizontalPodAutoscalerSpecFluent.MetricsNested<A> editMatchingMetric(Predicate<MetricSpecBuilder> predicate) {
        int index = -1;
        for (int i=0;i<metrics.size();i++) { 
        if (predicate.test(metrics.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching metrics. No match found.");
        return setNewMetricLike(index, buildMetric(index));
    }

    public Integer getMinReplicas() {
        return this.minReplicas;
    }

    public A withMinReplicas(Integer minReplicas) {
        this.minReplicas=minReplicas; return (A) this;
    }

    public Boolean hasMinReplicas() {
        return this.minReplicas != null;
    }

    
/**
 * This method has been deprecated, please use method buildScaleTargetRef instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference getScaleTargetRef() {
        return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildScaleTargetRef() {
        return this.scaleTargetRef!=null?this.scaleTargetRef.build():null;
    }

    public A withScaleTargetRef(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference scaleTargetRef) {
        _visitables.get("scaleTargetRef").remove(this.scaleTargetRef);
        if (scaleTargetRef!=null){ this.scaleTargetRef= new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(scaleTargetRef); _visitables.get("scaleTargetRef").add(this.scaleTargetRef);} return (A) this;
    }

    public Boolean hasScaleTargetRef() {
        return this.scaleTargetRef != null;
    }

    public A withNewScaleTargetRef(String apiVersion,String kind,String name) {
        return (A)withScaleTargetRef(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRef() {
        return new ScaleTargetRefNestedImpl();
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> withNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
        return new ScaleTargetRefNestedImpl(item);
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editScaleTargetRef() {
        return withNewScaleTargetRefLike(getScaleTargetRef());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRef() {
        return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder().build());
    }

    public HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<A> editOrNewScaleTargetRefLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
        return withNewScaleTargetRefLike(getScaleTargetRef() != null ? getScaleTargetRef(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HorizontalPodAutoscalerSpecFluentImpl that = (HorizontalPodAutoscalerSpecFluentImpl) o;
        if (maxReplicas != null ? !maxReplicas.equals(that.maxReplicas) :that.maxReplicas != null) return false;
        if (metrics != null ? !metrics.equals(that.metrics) :that.metrics != null) return false;
        if (minReplicas != null ? !minReplicas.equals(that.minReplicas) :that.minReplicas != null) return false;
        if (scaleTargetRef != null ? !scaleTargetRef.equals(that.scaleTargetRef) :that.scaleTargetRef != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(maxReplicas,  metrics,  minReplicas,  scaleTargetRef,  super.hashCode());
    }

    public class MetricsNestedImpl<N> extends MetricSpecFluentImpl<HorizontalPodAutoscalerSpecFluent.MetricsNested<N>> implements HorizontalPodAutoscalerSpecFluent.MetricsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final MetricSpecBuilder builder;
        private final int index;

        MetricsNestedImpl(int index,MetricSpec item) {
            this.index = index;
            this.builder = new MetricSpecBuilder(this, item);
        }

        MetricsNestedImpl() {
            this.index = -1;
            this.builder = new MetricSpecBuilder(this);
        }

        public N and() {
             return (N) HorizontalPodAutoscalerSpecFluentImpl.this.setToMetrics(index,builder.build());
        }

        public N endMetric() {
             return and();
        }
    }


    public class ScaleTargetRefNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluentImpl<HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>> implements HorizontalPodAutoscalerSpecFluent.ScaleTargetRefNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder builder;

        ScaleTargetRefNestedImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this, item);
        }

        ScaleTargetRefNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) HorizontalPodAutoscalerSpecFluentImpl.this.withScaleTargetRef(builder.build());
        }

        public N endScaleTargetRef() {
             return and();
        }
    }


}
