package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

public interface ExternalMetricStatusFluent<A extends ExternalMetricStatusFluent<A>> extends Fluent<A> {


    public Quantity getCurrentAverageValue();
    public A withCurrentAverageValue(Quantity currentAverageValue);
    public Boolean hasCurrentAverageValue();
    public A withNewCurrentAverageValue(String amount,String format);
    public A withNewCurrentAverageValue(String amount);
    public Quantity getCurrentValue();
    public A withCurrentValue(Quantity currentValue);
    public Boolean hasCurrentValue();
    public A withNewCurrentValue(String amount,String format);
    public A withNewCurrentValue(String amount);
    public String getMetricName();
    public A withMetricName(String metricName);
    public Boolean hasMetricName();
    public A withNewMetricName(String arg1);
    public A withNewMetricName(StringBuilder arg1);
    public A withNewMetricName(StringBuffer arg1);
    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getMetricSelector();
    public LabelSelector buildMetricSelector();
    public A withMetricSelector(LabelSelector metricSelector);
    public Boolean hasMetricSelector();
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelector();
    public ExternalMetricStatusFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item);
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editMetricSelector();
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelector();
    public ExternalMetricStatusFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item);
    public interface MetricSelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<ExternalMetricStatusFluent.MetricSelectorNested<N>> {

        public N and();
        public N endMetricSelector();    }


}
