package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.util.Collection;
import java.lang.Object;

public class HPAScalingRulesFluentImpl<A extends HPAScalingRulesFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements HPAScalingRulesFluent<A> {

    private List<HPAScalingPolicyBuilder> policies =  new ArrayList<HPAScalingPolicyBuilder>();
    private String selectPolicy;
    private Integer stabilizationWindowSeconds;

    public HPAScalingRulesFluentImpl() { 
    }


    public HPAScalingRulesFluentImpl(HPAScalingRules instance) { 
        this.withPolicies(instance.getPolicies()); 
        this.withSelectPolicy(instance.getSelectPolicy()); 
        this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds()); 
    }


    public A addToPolicies(int index,HPAScalingPolicy item) {
        if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").add(index >= 0 ? index : _visitables.get("policies").size(), builder);this.policies.add(index >= 0 ? index : policies.size(), builder); return (A)this;
    }

    public A setToPolicies(int index,HPAScalingPolicy item) {
        if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
        HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);
        if (index < 0 || index >= _visitables.get("policies").size()) { _visitables.get("policies").add(builder); } else { _visitables.get("policies").set(index, builder);}
        if (index < 0 || index >= policies.size()) { policies.add(builder); } else { policies.set(index, builder);}
         return (A)this;
    }

    public A addToPolicies(HPAScalingPolicy... items) {
        if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
        for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
    }

    public A addAllToPolicies(Collection<HPAScalingPolicy> items) {
        if (this.policies == null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>();}
        for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").add(builder);this.policies.add(builder);} return (A)this;
    }

    public A removeFromPolicies(HPAScalingPolicy... items) {
        for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").remove(builder);if (this.policies != null) {this.policies.remove(builder);}} return (A)this;
    }

    public A removeAllFromPolicies(Collection<HPAScalingPolicy> items) {
        for (HPAScalingPolicy item : items) {HPAScalingPolicyBuilder builder = new HPAScalingPolicyBuilder(item);_visitables.get("policies").remove(builder);if (this.policies != null) {this.policies.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromPolicies(Predicate<HPAScalingPolicyBuilder> predicate) {
        if (policies == null) return (A) this;
        final Iterator<HPAScalingPolicyBuilder> each = policies.iterator();
        final List visitables = _visitables.get("policies");
        while (each.hasNext()) {
          HPAScalingPolicyBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildPolicies instead.
 * @return The buildable object.
 */
@Deprecated public List<HPAScalingPolicy> getPolicies() {
        return build(policies);
    }

    public List<HPAScalingPolicy> buildPolicies() {
        return build(policies);
    }

    public HPAScalingPolicy buildPolicy(int index) {
        return this.policies.get(index).build();
    }

    public HPAScalingPolicy buildFirstPolicy() {
        return this.policies.get(0).build();
    }

    public HPAScalingPolicy buildLastPolicy() {
        return this.policies.get(policies.size() - 1).build();
    }

    public HPAScalingPolicy buildMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item: policies) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        for (HPAScalingPolicyBuilder item: policies) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withPolicies(List<HPAScalingPolicy> policies) {
        if (this.policies != null) { _visitables.get("policies").removeAll(this.policies);}
        if (policies != null) {this.policies = new ArrayList<HPAScalingPolicyBuilder>(); for (HPAScalingPolicy item : policies){this.addToPolicies(item);}} else { this.policies = null;} return (A) this;
    }

    public A withPolicies(HPAScalingPolicy... policies) {
        if (this.policies != null) {this.policies.clear();}
        if (policies != null) {for (HPAScalingPolicy item :policies){ this.addToPolicies(item);}} return (A) this;
    }

    public Boolean hasPolicies() {
        return policies != null && !policies.isEmpty();
    }

    public A addNewPolicy(Integer periodSeconds,String type,Integer value) {
        return (A)addToPolicies(new HPAScalingPolicy(periodSeconds, type, value));
    }

    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicy() {
        return new PoliciesNestedImpl();
    }

    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item) {
        return new PoliciesNestedImpl(-1, item);
    }

    public HPAScalingRulesFluent.PoliciesNested<A> setNewPolicyLike(int index,HPAScalingPolicy item) {
        return new PoliciesNestedImpl(index, item);
    }

    public HPAScalingRulesFluent.PoliciesNested<A> editPolicy(int index) {
        if (policies.size() <= index) throw new RuntimeException("Can't edit policies. Index exceeds size.");
        return setNewPolicyLike(index, buildPolicy(index));
    }

    public HPAScalingRulesFluent.PoliciesNested<A> editFirstPolicy() {
        if (policies.size() == 0) throw new RuntimeException("Can't edit first policies. The list is empty.");
        return setNewPolicyLike(0, buildPolicy(0));
    }

    public HPAScalingRulesFluent.PoliciesNested<A> editLastPolicy() {
        int index = policies.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last policies. The list is empty.");
        return setNewPolicyLike(index, buildPolicy(index));
    }

    public HPAScalingRulesFluent.PoliciesNested<A> editMatchingPolicy(Predicate<HPAScalingPolicyBuilder> predicate) {
        int index = -1;
        for (int i=0;i<policies.size();i++) { 
        if (predicate.test(policies.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching policies. No match found.");
        return setNewPolicyLike(index, buildPolicy(index));
    }

    public String getSelectPolicy() {
        return this.selectPolicy;
    }

    public A withSelectPolicy(String selectPolicy) {
        this.selectPolicy=selectPolicy; return (A) this;
    }

    public Boolean hasSelectPolicy() {
        return this.selectPolicy != null;
    }

    public A withNewSelectPolicy(String arg1) {
        return (A)withSelectPolicy(new String(arg1));
    }

    public A withNewSelectPolicy(StringBuilder arg1) {
        return (A)withSelectPolicy(new String(arg1));
    }

    public A withNewSelectPolicy(StringBuffer arg1) {
        return (A)withSelectPolicy(new String(arg1));
    }

    public Integer getStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds;
    }

    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds) {
        this.stabilizationWindowSeconds=stabilizationWindowSeconds; return (A) this;
    }

    public Boolean hasStabilizationWindowSeconds() {
        return this.stabilizationWindowSeconds != null;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        HPAScalingRulesFluentImpl that = (HPAScalingRulesFluentImpl) o;
        if (policies != null ? !policies.equals(that.policies) :that.policies != null) return false;
        if (selectPolicy != null ? !selectPolicy.equals(that.selectPolicy) :that.selectPolicy != null) return false;
        if (stabilizationWindowSeconds != null ? !stabilizationWindowSeconds.equals(that.stabilizationWindowSeconds) :that.stabilizationWindowSeconds != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(policies,  selectPolicy,  stabilizationWindowSeconds,  super.hashCode());
    }

    public class PoliciesNestedImpl<N> extends HPAScalingPolicyFluentImpl<HPAScalingRulesFluent.PoliciesNested<N>> implements HPAScalingRulesFluent.PoliciesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final HPAScalingPolicyBuilder builder;
        private final int index;

        PoliciesNestedImpl(int index,HPAScalingPolicy item) {
            this.index = index;
            this.builder = new HPAScalingPolicyBuilder(this, item);
        }

        PoliciesNestedImpl() {
            this.index = -1;
            this.builder = new HPAScalingPolicyBuilder(this);
        }

        public N and() {
             return (N) HPAScalingRulesFluentImpl.this.setToPolicies(index,builder.build());
        }

        public N endPolicy() {
             return and();
        }
    }


}
