package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ObjectMetricStatusFluentImpl<A extends ObjectMetricStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ObjectMetricStatusFluent<A> {

    private Quantity averageValue;
    private Quantity currentValue;
    private String metricName;
    private LabelSelectorBuilder selector;
    private io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder target;

    public ObjectMetricStatusFluentImpl() { 
    }


    public ObjectMetricStatusFluentImpl(ObjectMetricStatus instance) { 
        this.withAverageValue(instance.getAverageValue()); 
        this.withCurrentValue(instance.getCurrentValue()); 
        this.withMetricName(instance.getMetricName()); 
        this.withSelector(instance.getSelector()); 
        this.withTarget(instance.getTarget()); 
    }


    public Quantity getAverageValue() {
        return this.averageValue;
    }

    public A withAverageValue(Quantity averageValue) {
        this.averageValue=averageValue; return (A) this;
    }

    public Boolean hasAverageValue() {
        return this.averageValue != null;
    }

    public A withNewAverageValue(String amount,String format) {
        return (A)withAverageValue(new Quantity(amount, format));
    }

    public A withNewAverageValue(String amount) {
        return (A)withAverageValue(new Quantity(amount));
    }

    public Quantity getCurrentValue() {
        return this.currentValue;
    }

    public A withCurrentValue(Quantity currentValue) {
        this.currentValue=currentValue; return (A) this;
    }

    public Boolean hasCurrentValue() {
        return this.currentValue != null;
    }

    public A withNewCurrentValue(String amount,String format) {
        return (A)withCurrentValue(new Quantity(amount, format));
    }

    public A withNewCurrentValue(String amount) {
        return (A)withCurrentValue(new Quantity(amount));
    }

    public String getMetricName() {
        return this.metricName;
    }

    public A withMetricName(String metricName) {
        this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName() {
        return this.metricName != null;
    }

    public A withNewMetricName(String arg1) {
        return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1) {
        return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1) {
        return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public LabelSelector buildSelector() {
        return this.selector!=null?this.selector.build():null;
    }

    public A withSelector(LabelSelector selector) {
        _visitables.get("selector").remove(this.selector);
        if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
    }

    public Boolean hasSelector() {
        return this.selector != null;
    }

    public ObjectMetricStatusFluent.SelectorNested<A> withNewSelector() {
        return new SelectorNestedImpl();
    }

    public ObjectMetricStatusFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
        return new SelectorNestedImpl(item);
    }

    public ObjectMetricStatusFluent.SelectorNested<A> editSelector() {
        return withNewSelectorLike(getSelector());
    }

    public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelector() {
        return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
    }

    public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
        return withNewSelectorLike(getSelector() != null ? getSelector(): item);
    }

    
/**
 * This method has been deprecated, please use method buildTarget instead.
 * @return The buildable object.
 */
@Deprecated public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference getTarget() {
        return this.target!=null?this.target.build():null;
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference buildTarget() {
        return this.target!=null?this.target.build():null;
    }

    public A withTarget(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference target) {
        _visitables.get("target").remove(this.target);
        if (target!=null){ this.target= new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(target); _visitables.get("target").add(this.target);} return (A) this;
    }

    public Boolean hasTarget() {
        return this.target != null;
    }

    public A withNewTarget(String apiVersion,String kind,String name) {
        return (A)withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
    }

    public ObjectMetricStatusFluent.TargetNested<A> withNewTarget() {
        return new TargetNestedImpl();
    }

    public ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
        return new TargetNestedImpl(item);
    }

    public ObjectMetricStatusFluent.TargetNested<A> editTarget() {
        return withNewTargetLike(getTarget());
    }

    public ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget() {
        return withNewTargetLike(getTarget() != null ? getTarget(): new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder().build());
    }

    public ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
        return withNewTargetLike(getTarget() != null ? getTarget(): item);
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl) o;
        if (averageValue != null ? !averageValue.equals(that.averageValue) :that.averageValue != null) return false;
        if (currentValue != null ? !currentValue.equals(that.currentValue) :that.currentValue != null) return false;
        if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
        if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
        if (target != null ? !target.equals(that.target) :that.target != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(averageValue,  currentValue,  metricName,  selector,  target,  super.hashCode());
    }

    public class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ObjectMetricStatusFluent.SelectorNested<N>> implements ObjectMetricStatusFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final LabelSelectorBuilder builder;

        SelectorNestedImpl(LabelSelector item) {
            this.builder = new LabelSelectorBuilder(this, item);
        }

        SelectorNestedImpl() {
            this.builder = new LabelSelectorBuilder(this);
        }

        public N and() {
             return (N) ObjectMetricStatusFluentImpl.this.withSelector(builder.build());
        }

        public N endSelector() {
             return and();
        }
    }


    public class TargetNestedImpl<N> extends io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluent.TargetNested<N>> implements ObjectMetricStatusFluent.TargetNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder builder;

        TargetNestedImpl(io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReference item) {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this, item);
        }

        TargetNestedImpl() {
            this.builder = new io.fabric8.kubernetes.api.model.autoscaling.v2beta1.CrossVersionObjectReferenceBuilder(this);
        }

        public N and() {
             return (N) ObjectMetricStatusFluentImpl.this.withTarget(builder.build());
        }

        public N endTarget() {
             return and();
        }
    }


}
