
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.IntOrString;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.BuildableReference;
import lombok.EqualsAndHashCode;
import lombok.ToString;


/**
 * 
 * 
 */
@JsonDeserialize(using = com.fasterxml.jackson.databind.JsonDeserializer.None.class)
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "apiVersion",
    "kind",
    "metadata",
    "external",
    "object",
    "pods",
    "resource",
    "type"
})
@ToString
@EqualsAndHashCode
@Buildable(editableEnabled = false, validationEnabled = false, generateBuilderPackage = false, lazyCollectionInitEnabled = false, builderPackage = "io.fabric8.kubernetes.api.builder", refs = {
    @BuildableReference(ObjectMeta.class),
    @BuildableReference(LabelSelector.class),
    @BuildableReference(Container.class),
    @BuildableReference(PodTemplateSpec.class),
    @BuildableReference(ResourceRequirements.class),
    @BuildableReference(IntOrString.class),
    @BuildableReference(ObjectReference.class),
    @BuildableReference(LocalObjectReference.class),
    @BuildableReference(PersistentVolumeClaim.class)
})
public class MetricStatus implements KubernetesResource
{

    /**
     * 
     * 
     */
    @JsonProperty("external")
    private ExternalMetricStatus external;
    /**
     * 
     * 
     */
    @JsonProperty("object")
    private ObjectMetricStatus object;
    /**
     * 
     * 
     */
    @JsonProperty("pods")
    private PodsMetricStatus pods;
    /**
     * 
     * 
     */
    @JsonProperty("resource")
    private ResourceMetricStatus resource;
    /**
     * 
     * 
     */
    @JsonProperty("type")
    private String type;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    /**
     * No args constructor for use in serialization
     * 
     */
    public MetricStatus() {
    }

    /**
     * 
     * @param external
     * @param resource
     * @param pods
     * @param type
     * @param object
     */
    public MetricStatus(ExternalMetricStatus external, ObjectMetricStatus object, PodsMetricStatus pods, ResourceMetricStatus resource, String type) {
        this.external = external;
        this.object = object;
        this.pods = pods;
        this.resource = resource;
        this.type = type;
    }

    /**
     * 
     * 
     * @return
     *     The external
     */
    @JsonProperty("external")
    public ExternalMetricStatus getExternal() {
        return external;
    }

    /**
     * 
     * 
     * @param external
     *     The external
     */
    @JsonProperty("external")
    public void setExternal(ExternalMetricStatus external) {
        this.external = external;
    }

    /**
     * 
     * 
     * @return
     *     The object
     */
    @JsonProperty("object")
    public ObjectMetricStatus getObject() {
        return object;
    }

    /**
     * 
     * 
     * @param object
     *     The object
     */
    @JsonProperty("object")
    public void setObject(ObjectMetricStatus object) {
        this.object = object;
    }

    /**
     * 
     * 
     * @return
     *     The pods
     */
    @JsonProperty("pods")
    public PodsMetricStatus getPods() {
        return pods;
    }

    /**
     * 
     * 
     * @param pods
     *     The pods
     */
    @JsonProperty("pods")
    public void setPods(PodsMetricStatus pods) {
        this.pods = pods;
    }

    /**
     * 
     * 
     * @return
     *     The resource
     */
    @JsonProperty("resource")
    public ResourceMetricStatus getResource() {
        return resource;
    }

    /**
     * 
     * 
     * @param resource
     *     The resource
     */
    @JsonProperty("resource")
    public void setResource(ResourceMetricStatus resource) {
        this.resource = resource;
    }

    /**
     * 
     * 
     * @return
     *     The type
     */
    @JsonProperty("type")
    public String getType() {
        return type;
    }

    /**
     * 
     * 
     * @param type
     *     The type
     */
    @JsonProperty("type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

}
