package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class HPAScalingRulesBuilder extends HPAScalingRulesFluentImpl<HPAScalingRulesBuilder> implements VisitableBuilder<HPAScalingRules,HPAScalingRulesBuilder>{

    HPAScalingRulesFluent<?> fluent;
    Boolean validationEnabled;

    public HPAScalingRulesBuilder(){
            this(true);
    }
    public HPAScalingRulesBuilder(Boolean validationEnabled){
            this(new HPAScalingRules(), validationEnabled);
    }
    public HPAScalingRulesBuilder(HPAScalingRulesFluent<?> fluent){
            this(fluent, true);
    }
    public HPAScalingRulesBuilder(HPAScalingRulesFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new HPAScalingRules(), validationEnabled);
    }
    public HPAScalingRulesBuilder(HPAScalingRulesFluent<?> fluent,HPAScalingRules instance){
            this(fluent, instance, true);
    }
    public HPAScalingRulesBuilder(HPAScalingRulesFluent<?> fluent,HPAScalingRules instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withPolicies(instance.getPolicies()); 
            fluent.withSelectPolicy(instance.getSelectPolicy()); 
            fluent.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds()); 
            this.validationEnabled = validationEnabled; 
    }
    public HPAScalingRulesBuilder(HPAScalingRules instance){
            this(instance,true);
    }
    public HPAScalingRulesBuilder(HPAScalingRules instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withPolicies(instance.getPolicies()); 
            this.withSelectPolicy(instance.getSelectPolicy()); 
            this.withStabilizationWindowSeconds(instance.getStabilizationWindowSeconds()); 
            this.validationEnabled = validationEnabled; 
    }

    public HPAScalingRules build(){
            HPAScalingRules buildable = new HPAScalingRules(fluent.getPolicies(),fluent.getSelectPolicy(),fluent.getStabilizationWindowSeconds());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HPAScalingRulesBuilder that = (HPAScalingRulesBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
