package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricStatusBuilder extends io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluentImpl<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusBuilder>{

    io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluent<?> fluent;
    Boolean validationEnabled;

    public ExternalMetricStatusBuilder(){
            this(true);
    }
    public ExternalMetricStatusBuilder(Boolean validationEnabled){
            this(new ExternalMetricStatus(), validationEnabled);
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluent<?> fluent){
            this(fluent, true);
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new ExternalMetricStatus(), validationEnabled);
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus instance){
            this(fluent, instance, true);
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCurrent(instance.getCurrent()); 
            fluent.withMetric(instance.getMetric()); 
            this.validationEnabled = validationEnabled; 
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus instance){
            this(instance,true);
    }
    public ExternalMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCurrent(instance.getCurrent()); 
            this.withMetric(instance.getMetric()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricStatus build(){
            ExternalMetricStatus buildable = new ExternalMetricStatus(fluent.getCurrent(),fluent.getMetric());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ExternalMetricStatusBuilder that = (ExternalMetricStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
