package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;

public class ExternalMetricSourceFluentImpl<A extends ExternalMetricSourceFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ExternalMetricSourceFluent<A>{

    private String metricName;
    private LabelSelectorBuilder metricSelector;
    private Quantity targetAverageValue;
    private Quantity targetValue;

    public ExternalMetricSourceFluentImpl(){
    }
    public ExternalMetricSourceFluentImpl(ExternalMetricSource instance){
            this.withMetricName(instance.getMetricName()); 
            this.withMetricSelector(instance.getMetricSelector()); 
            this.withTargetAverageValue(instance.getTargetAverageValue()); 
            this.withTargetValue(instance.getTargetValue()); 
    }

    public String getMetricName(){
            return this.metricName;
    }

    public A withMetricName(String metricName){
            this.metricName=metricName; return (A) this;
    }

    public Boolean hasMetricName(){
            return this.metricName != null;
    }

    public A withNewMetricName(String arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuilder arg1){
            return (A)withMetricName(new String(arg1));
    }

    public A withNewMetricName(StringBuffer arg1){
            return (A)withMetricName(new String(arg1));
    }

    
/**
 * This method has been deprecated, please use method buildMetricSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public LabelSelector buildMetricSelector(){
            return this.metricSelector!=null?this.metricSelector.build():null;
    }

    public A withMetricSelector(LabelSelector metricSelector){
            _visitables.get("metricSelector").remove(this.metricSelector);
            if (metricSelector!=null){ this.metricSelector= new LabelSelectorBuilder(metricSelector); _visitables.get("metricSelector").add(this.metricSelector);} return (A) this;
    }

    public Boolean hasMetricSelector(){
            return this.metricSelector != null;
    }

    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelector(){
            return new MetricSelectorNestedImpl();
    }

    public ExternalMetricSourceFluent.MetricSelectorNested<A> withNewMetricSelectorLike(LabelSelector item){
            return new MetricSelectorNestedImpl(item);
    }

    public ExternalMetricSourceFluent.MetricSelectorNested<A> editMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector());
    }

    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelector(){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): new LabelSelectorBuilder().build());
    }

    public ExternalMetricSourceFluent.MetricSelectorNested<A> editOrNewMetricSelectorLike(LabelSelector item){
            return withNewMetricSelectorLike(getMetricSelector() != null ? getMetricSelector(): item);
    }

    public Quantity getTargetAverageValue(){
            return this.targetAverageValue;
    }

    public A withTargetAverageValue(Quantity targetAverageValue){
            this.targetAverageValue=targetAverageValue; return (A) this;
    }

    public Boolean hasTargetAverageValue(){
            return this.targetAverageValue != null;
    }

    public A withNewTargetAverageValue(String amount,String format){
            return (A)withTargetAverageValue(new Quantity(amount, format));
    }

    public A withNewTargetAverageValue(String amount){
            return (A)withTargetAverageValue(new Quantity(amount));
    }

    public Quantity getTargetValue(){
            return this.targetValue;
    }

    public A withTargetValue(Quantity targetValue){
            this.targetValue=targetValue; return (A) this;
    }

    public Boolean hasTargetValue(){
            return this.targetValue != null;
    }

    public A withNewTargetValue(String amount,String format){
            return (A)withTargetValue(new Quantity(amount, format));
    }

    public A withNewTargetValue(String amount){
            return (A)withTargetValue(new Quantity(amount));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            ExternalMetricSourceFluentImpl that = (ExternalMetricSourceFluentImpl) o;
            if (metricName != null ? !metricName.equals(that.metricName) :that.metricName != null) return false;
            if (metricSelector != null ? !metricSelector.equals(that.metricSelector) :that.metricSelector != null) return false;
            if (targetAverageValue != null ? !targetAverageValue.equals(that.targetAverageValue) :that.targetAverageValue != null) return false;
            if (targetValue != null ? !targetValue.equals(that.targetValue) :that.targetValue != null) return false;
            return true;
    }


    public class MetricSelectorNestedImpl<N> extends LabelSelectorFluentImpl<ExternalMetricSourceFluent.MetricSelectorNested<N>> implements ExternalMetricSourceFluent.MetricSelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LabelSelectorBuilder builder;
    
            MetricSelectorNestedImpl(LabelSelector item){
                    this.builder = new LabelSelectorBuilder(this, item);
            }
            MetricSelectorNestedImpl(){
                    this.builder = new LabelSelectorBuilder(this);
            }
    
    public N and(){
            return (N) ExternalMetricSourceFluentImpl.this.withMetricSelector(builder.build());
    }
    public N endMetricSelector(){
            return and();
    }

}


}
