package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.builder.Predicate;
import java.lang.Integer;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public interface HPAScalingRulesFluent<A extends HPAScalingRulesFluent<A>> extends Fluent<A>{


    public A addToPolicies(int index,HPAScalingPolicy item);
    public A setToPolicies(int index,HPAScalingPolicy item);
    public A addToPolicies(HPAScalingPolicy... items);
    public A addAllToPolicies(Collection<HPAScalingPolicy> items);
    public A removeFromPolicies(HPAScalingPolicy... items);
    public A removeAllFromPolicies(Collection<HPAScalingPolicy> items);
    public A removeMatchingFromPolicies(io.fabric8.kubernetes.api.builder.Predicate<HPAScalingPolicyBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildPolicies instead.
 * @return The buildable object.
 */
@Deprecated public List<HPAScalingPolicy> getPolicies();
    public List<HPAScalingPolicy> buildPolicies();
    public HPAScalingPolicy buildPolicy(int index);
    public HPAScalingPolicy buildFirstPolicy();
    public HPAScalingPolicy buildLastPolicy();
    public HPAScalingPolicy buildMatchingPolicy(io.fabric8.kubernetes.api.builder.Predicate<HPAScalingPolicyBuilder> predicate);
    public Boolean hasMatchingPolicy(io.fabric8.kubernetes.api.builder.Predicate<HPAScalingPolicyBuilder> predicate);
    public A withPolicies(List<HPAScalingPolicy> policies);
    public A withPolicies(HPAScalingPolicy... policies);
    public Boolean hasPolicies();
    public A addNewPolicy(Integer periodSeconds,String type,Integer value);
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicy();
    public HPAScalingRulesFluent.PoliciesNested<A> addNewPolicyLike(HPAScalingPolicy item);
    public HPAScalingRulesFluent.PoliciesNested<A> setNewPolicyLike(int index,HPAScalingPolicy item);
    public HPAScalingRulesFluent.PoliciesNested<A> editPolicy(int index);
    public HPAScalingRulesFluent.PoliciesNested<A> editFirstPolicy();
    public HPAScalingRulesFluent.PoliciesNested<A> editLastPolicy();
    public HPAScalingRulesFluent.PoliciesNested<A> editMatchingPolicy(io.fabric8.kubernetes.api.builder.Predicate<HPAScalingPolicyBuilder> predicate);
    public String getSelectPolicy();
    public A withSelectPolicy(String selectPolicy);
    public Boolean hasSelectPolicy();
    public A withNewSelectPolicy(String arg1);
    public A withNewSelectPolicy(StringBuilder arg1);
    public A withNewSelectPolicy(StringBuffer arg1);
    public Integer getStabilizationWindowSeconds();
    public A withStabilizationWindowSeconds(Integer stabilizationWindowSeconds);
    public Boolean hasStabilizationWindowSeconds();

    public interface PoliciesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HPAScalingPolicyFluent<HPAScalingRulesFluent.PoliciesNested<N>>{

        
    public N and();    public N endPolicy();
}


}
