package io.fabric8.kubernetes.api.model.apps;

import java.lang.String;
import io.fabric8.kubernetes.api.model.ContainerBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionBuilder;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.GenericKubernetesResource;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtensionFluent;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceBuilder;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;
import io.fabric8.kubernetes.api.model.ContainerFluent;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ResourceRequirements;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.runtime.RawExtension;
import io.fabric8.kubernetes.api.model.GenericKubernetesResourceFluent;
import io.fabric8.kubernetes.api.model.ResourceRequirementsBuilder;
import io.fabric8.kubernetes.api.builder.Nested;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class ControllerRevisionFluent<A extends ControllerRevisionFluent<A>> extends BaseFluent<A>{
  public ControllerRevisionFluent() {
  }
  
  public ControllerRevisionFluent(ControllerRevision instance) {
    this.copyInstance(instance);
  }
  private String apiVersion;
  private VisitableBuilder<? extends KubernetesResource,?> data;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Long revision;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(ControllerRevision instance) {
    instance = (instance != null ? instance : new ControllerRevision());
    if (instance != null) {
          this.withApiVersion(instance.getApiVersion());
          this.withData(instance.getData());
          this.withKind(instance.getKind());
          this.withMetadata(instance.getMetadata());
          this.withRevision(instance.getRevision());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public String getApiVersion() {
    return this.apiVersion;
  }
  
  public A withApiVersion(String apiVersion) {
    this.apiVersion = apiVersion;
    return (A) this;
  }
  
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  public KubernetesResource buildData() {
    return this.data != null ? this.data.build() : null;
  }
  
  public A withData(KubernetesResource data) {
    if (data == null) {
        this.data = null;
        this._visitables.remove("data");
        return (A) this;
    } else {
        VisitableBuilder<? extends KubernetesResource,?> builder = builder(data);;
        this._visitables.clear();
        this._visitables.get("data").add(builder);
        this.data = builder;
        return (A) this;
    }
  }
  
  public boolean hasData() {
    return this.data != null;
  }
  
  public DeploymentListDataNested<A> withNewDeploymentListData() {
    return new DeploymentListDataNested(null);
  }
  
  public DeploymentListDataNested<A> withNewDeploymentListDataLike(DeploymentList item) {
    return new DeploymentListDataNested(item);
  }
  
  public DaemonSetUpdateStrategyDataNested<A> withNewDaemonSetUpdateStrategyData() {
    return new DaemonSetUpdateStrategyDataNested(null);
  }
  
  public DaemonSetUpdateStrategyDataNested<A> withNewDaemonSetUpdateStrategyDataLike(DaemonSetUpdateStrategy item) {
    return new DaemonSetUpdateStrategyDataNested(item);
  }
  
  public ReplicaSetDataNested<A> withNewReplicaSetData() {
    return new ReplicaSetDataNested(null);
  }
  
  public ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
    return new ReplicaSetDataNested(item);
  }
  
  public LabelSelectorDataNested<A> withNewLabelSelectorData() {
    return new LabelSelectorDataNested(null);
  }
  
  public LabelSelectorDataNested<A> withNewLabelSelectorDataLike(LabelSelector item) {
    return new LabelSelectorDataNested(item);
  }
  
  public ContainerDataNested<A> withNewContainerData() {
    return new ContainerDataNested(null);
  }
  
  public ContainerDataNested<A> withNewContainerDataLike(Container item) {
    return new ContainerDataNested(item);
  }
  
  public GenericKubernetesResourceDataNested<A> withNewGenericKubernetesResourceData() {
    return new GenericKubernetesResourceDataNested(null);
  }
  
  public GenericKubernetesResourceDataNested<A> withNewGenericKubernetesResourceDataLike(GenericKubernetesResource item) {
    return new GenericKubernetesResourceDataNested(item);
  }
  
  public StatefulSetStatusDataNested<A> withNewStatefulSetStatusData() {
    return new StatefulSetStatusDataNested(null);
  }
  
  public StatefulSetStatusDataNested<A> withNewStatefulSetStatusDataLike(StatefulSetStatus item) {
    return new StatefulSetStatusDataNested(item);
  }
  
  public StatefulSetOrdinalsDataNested<A> withNewStatefulSetOrdinalsData() {
    return new StatefulSetOrdinalsDataNested(null);
  }
  
  public StatefulSetOrdinalsDataNested<A> withNewStatefulSetOrdinalsDataLike(StatefulSetOrdinals item) {
    return new StatefulSetOrdinalsDataNested(item);
  }
  
  public A withNewStatefulSetOrdinalsData(Integer start) {
    return (A)withData(new StatefulSetOrdinals(start));
  }
  
  public RollingUpdateStatefulSetStrategyDataNested<A> withNewRollingUpdateStatefulSetStrategyData() {
    return new RollingUpdateStatefulSetStrategyDataNested(null);
  }
  
  public RollingUpdateStatefulSetStrategyDataNested<A> withNewRollingUpdateStatefulSetStrategyDataLike(RollingUpdateStatefulSetStrategy item) {
    return new RollingUpdateStatefulSetStrategyDataNested(item);
  }
  
  public ReplicaSetConditionDataNested<A> withNewReplicaSetConditionData() {
    return new ReplicaSetConditionDataNested(null);
  }
  
  public ReplicaSetConditionDataNested<A> withNewReplicaSetConditionDataLike(ReplicaSetCondition item) {
    return new ReplicaSetConditionDataNested(item);
  }
  
  public A withNewReplicaSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withData(new ReplicaSetCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public PodTemplateSpecDataNested<A> withNewPodTemplateSpecData() {
    return new PodTemplateSpecDataNested(null);
  }
  
  public PodTemplateSpecDataNested<A> withNewPodTemplateSpecDataLike(PodTemplateSpec item) {
    return new PodTemplateSpecDataNested(item);
  }
  
  public LocalObjectReferenceDataNested<A> withNewLocalObjectReferenceData() {
    return new LocalObjectReferenceDataNested(null);
  }
  
  public LocalObjectReferenceDataNested<A> withNewLocalObjectReferenceDataLike(LocalObjectReference item) {
    return new LocalObjectReferenceDataNested(item);
  }
  
  public A withNewLocalObjectReferenceData(String name) {
    return (A)withData(new LocalObjectReference(name));
  }
  
  public ReplicaSetSpecDataNested<A> withNewReplicaSetSpecData() {
    return new ReplicaSetSpecDataNested(null);
  }
  
  public ReplicaSetSpecDataNested<A> withNewReplicaSetSpecDataLike(ReplicaSetSpec item) {
    return new ReplicaSetSpecDataNested(item);
  }
  
  public ResourceRequirementsDataNested<A> withNewResourceRequirementsData() {
    return new ResourceRequirementsDataNested(null);
  }
  
  public ResourceRequirementsDataNested<A> withNewResourceRequirementsDataLike(ResourceRequirements item) {
    return new ResourceRequirementsDataNested(item);
  }
  
  public RollingUpdateDeploymentDataNested<A> withNewRollingUpdateDeploymentData() {
    return new RollingUpdateDeploymentDataNested(null);
  }
  
  public RollingUpdateDeploymentDataNested<A> withNewRollingUpdateDeploymentDataLike(RollingUpdateDeployment item) {
    return new RollingUpdateDeploymentDataNested(item);
  }
  
  public ControllerRevisionListDataNested<A> withNewControllerRevisionListData() {
    return new ControllerRevisionListDataNested(null);
  }
  
  public ControllerRevisionListDataNested<A> withNewControllerRevisionListDataLike(ControllerRevisionList item) {
    return new ControllerRevisionListDataNested(item);
  }
  
  public StatefulSetListDataNested<A> withNewStatefulSetListData() {
    return new StatefulSetListDataNested(null);
  }
  
  public StatefulSetListDataNested<A> withNewStatefulSetListDataLike(StatefulSetList item) {
    return new StatefulSetListDataNested(item);
  }
  
  public DaemonSetDataNested<A> withNewDaemonSetData() {
    return new DaemonSetDataNested(null);
  }
  
  public DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
    return new DaemonSetDataNested(item);
  }
  
  public DeploymentSpecDataNested<A> withNewDeploymentSpecData() {
    return new DeploymentSpecDataNested(null);
  }
  
  public DeploymentSpecDataNested<A> withNewDeploymentSpecDataLike(DeploymentSpec item) {
    return new DeploymentSpecDataNested(item);
  }
  
  public DeploymentStatusDataNested<A> withNewDeploymentStatusData() {
    return new DeploymentStatusDataNested(null);
  }
  
  public DeploymentStatusDataNested<A> withNewDeploymentStatusDataLike(DeploymentStatus item) {
    return new DeploymentStatusDataNested(item);
  }
  
  public ReplicaSetStatusDataNested<A> withNewReplicaSetStatusData() {
    return new ReplicaSetStatusDataNested(null);
  }
  
  public ReplicaSetStatusDataNested<A> withNewReplicaSetStatusDataLike(ReplicaSetStatus item) {
    return new ReplicaSetStatusDataNested(item);
  }
  
  public ControllerRevisionDataNested<A> withNewControllerRevisionData() {
    return new ControllerRevisionDataNested(null);
  }
  
  public ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
    return new ControllerRevisionDataNested(item);
  }
  
  public DeploymentConditionDataNested<A> withNewDeploymentConditionData() {
    return new DeploymentConditionDataNested(null);
  }
  
  public DeploymentConditionDataNested<A> withNewDeploymentConditionDataLike(DeploymentCondition item) {
    return new DeploymentConditionDataNested(item);
  }
  
  public DaemonSetConditionDataNested<A> withNewDaemonSetConditionData() {
    return new DaemonSetConditionDataNested(null);
  }
  
  public DaemonSetConditionDataNested<A> withNewDaemonSetConditionDataLike(DaemonSetCondition item) {
    return new DaemonSetConditionDataNested(item);
  }
  
  public A withNewDaemonSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withData(new DaemonSetCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<A> withNewStatefulSetPersistentVolumeClaimRetentionPolicyData() {
    return new StatefulSetPersistentVolumeClaimRetentionPolicyDataNested(null);
  }
  
  public StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<A> withNewStatefulSetPersistentVolumeClaimRetentionPolicyDataLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return new StatefulSetPersistentVolumeClaimRetentionPolicyDataNested(item);
  }
  
  public A withNewStatefulSetPersistentVolumeClaimRetentionPolicyData(String whenDeleted,String whenScaled) {
    return (A)withData(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
  }
  
  public DaemonSetListDataNested<A> withNewDaemonSetListData() {
    return new DaemonSetListDataNested(null);
  }
  
  public DaemonSetListDataNested<A> withNewDaemonSetListDataLike(DaemonSetList item) {
    return new DaemonSetListDataNested(item);
  }
  
  public StatefulSetConditionDataNested<A> withNewStatefulSetConditionData() {
    return new StatefulSetConditionDataNested(null);
  }
  
  public StatefulSetConditionDataNested<A> withNewStatefulSetConditionDataLike(StatefulSetCondition item) {
    return new StatefulSetConditionDataNested(item);
  }
  
  public A withNewStatefulSetConditionData(String lastTransitionTime,String message,String reason,String status,String type) {
    return (A)withData(new StatefulSetCondition(lastTransitionTime, message, reason, status, type));
  }
  
  public ReplicaSetListDataNested<A> withNewReplicaSetListData() {
    return new ReplicaSetListDataNested(null);
  }
  
  public ReplicaSetListDataNested<A> withNewReplicaSetListDataLike(ReplicaSetList item) {
    return new ReplicaSetListDataNested(item);
  }
  
  public ObjectReferenceDataNested<A> withNewObjectReferenceData() {
    return new ObjectReferenceDataNested(null);
  }
  
  public ObjectReferenceDataNested<A> withNewObjectReferenceDataLike(ObjectReference item) {
    return new ObjectReferenceDataNested(item);
  }
  
  public DaemonSetStatusDataNested<A> withNewDaemonSetStatusData() {
    return new DaemonSetStatusDataNested(null);
  }
  
  public DaemonSetStatusDataNested<A> withNewDaemonSetStatusDataLike(DaemonSetStatus item) {
    return new DaemonSetStatusDataNested(item);
  }
  
  public RawExtensionDataNested<A> withNewRawExtensionData() {
    return new RawExtensionDataNested(null);
  }
  
  public RawExtensionDataNested<A> withNewRawExtensionDataLike(RawExtension item) {
    return new RawExtensionDataNested(item);
  }
  
  public A withNewRawExtensionData(Object value) {
    return (A)withData(new RawExtension(value));
  }
  
  public StatefulSetDataNested<A> withNewStatefulSetData() {
    return new StatefulSetDataNested(null);
  }
  
  public StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
    return new StatefulSetDataNested(item);
  }
  
  public StatefulSetSpecDataNested<A> withNewStatefulSetSpecData() {
    return new StatefulSetSpecDataNested(null);
  }
  
  public StatefulSetSpecDataNested<A> withNewStatefulSetSpecDataLike(StatefulSetSpec item) {
    return new StatefulSetSpecDataNested(item);
  }
  
  public RollingUpdateDaemonSetDataNested<A> withNewRollingUpdateDaemonSetData() {
    return new RollingUpdateDaemonSetDataNested(null);
  }
  
  public RollingUpdateDaemonSetDataNested<A> withNewRollingUpdateDaemonSetDataLike(RollingUpdateDaemonSet item) {
    return new RollingUpdateDaemonSetDataNested(item);
  }
  
  public ObjectMetaDataNested<A> withNewObjectMetaData() {
    return new ObjectMetaDataNested(null);
  }
  
  public ObjectMetaDataNested<A> withNewObjectMetaDataLike(ObjectMeta item) {
    return new ObjectMetaDataNested(item);
  }
  
  public PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
    return new PersistentVolumeClaimDataNested(null);
  }
  
  public PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
    return new PersistentVolumeClaimDataNested(item);
  }
  
  public DeploymentStrategyDataNested<A> withNewDeploymentStrategyData() {
    return new DeploymentStrategyDataNested(null);
  }
  
  public DeploymentStrategyDataNested<A> withNewDeploymentStrategyDataLike(DeploymentStrategy item) {
    return new DeploymentStrategyDataNested(item);
  }
  
  public DaemonSetSpecDataNested<A> withNewDaemonSetSpecData() {
    return new DaemonSetSpecDataNested(null);
  }
  
  public DaemonSetSpecDataNested<A> withNewDaemonSetSpecDataLike(DaemonSetSpec item) {
    return new DaemonSetSpecDataNested(item);
  }
  
  public StatefulSetUpdateStrategyDataNested<A> withNewStatefulSetUpdateStrategyData() {
    return new StatefulSetUpdateStrategyDataNested(null);
  }
  
  public StatefulSetUpdateStrategyDataNested<A> withNewStatefulSetUpdateStrategyDataLike(StatefulSetUpdateStrategy item) {
    return new StatefulSetUpdateStrategyDataNested(item);
  }
  
  public DeploymentDataNested<A> withNewDeploymentData() {
    return new DeploymentDataNested(null);
  }
  
  public DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
    return new DeploymentDataNested(item);
  }
  
  public String getKind() {
    return this.kind;
  }
  
  public A withKind(String kind) {
    this.kind = kind;
    return (A) this;
  }
  
  public boolean hasKind() {
    return this.kind != null;
  }
  
  public ObjectMeta buildMetadata() {
    return this.metadata != null ? this.metadata.build() : null;
  }
  
  public A withMetadata(ObjectMeta metadata) {
    this._visitables.remove("metadata");
    if (metadata != null) {
        this.metadata = new ObjectMetaBuilder(metadata);
        this._visitables.get("metadata").add(this.metadata);
    } else {
        this.metadata = null;
        this._visitables.get("metadata").remove(this.metadata);
    }
    return (A) this;
  }
  
  public boolean hasMetadata() {
    return this.metadata != null;
  }
  
  public MetadataNested<A> withNewMetadata() {
    return new MetadataNested(null);
  }
  
  public MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new MetadataNested(item);
  }
  
  public MetadataNested<A> editMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(null));
  }
  
  public MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(new ObjectMetaBuilder().build()));
  }
  
  public MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(java.util.Optional.ofNullable(buildMetadata()).orElse(item));
  }
  
  public Long getRevision() {
    return this.revision;
  }
  
  public A withRevision(Long revision) {
    this.revision = revision;
    return (A) this;
  }
  
  public boolean hasRevision() {
    return this.revision != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ControllerRevisionFluent that = (ControllerRevisionFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;
    if (!java.util.Objects.equals(data, that.data)) return false;
    if (!java.util.Objects.equals(kind, that.kind)) return false;
    if (!java.util.Objects.equals(metadata, that.metadata)) return false;
    if (!java.util.Objects.equals(revision, that.revision)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  revision,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  protected static <T>VisitableBuilder<T,?> builder(Object item) {
    switch (item.getClass().getName()) {
    case "io.fabric8.kubernetes.api.model.apps."+"DeploymentList": return (VisitableBuilder<T, ?>)new DeploymentListBuilder((DeploymentList) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSetUpdateStrategy": return (VisitableBuilder<T, ?>)new DaemonSetUpdateStrategyBuilder((DaemonSetUpdateStrategy) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ReplicaSet": return (VisitableBuilder<T, ?>)new ReplicaSetBuilder((ReplicaSet) item);
    case "io.fabric8.kubernetes.api.model."+"LabelSelector": return (VisitableBuilder<T, ?>)new LabelSelectorBuilder((LabelSelector) item);
    case "io.fabric8.kubernetes.api.model."+"Container": return (VisitableBuilder<T, ?>)new ContainerBuilder((Container) item);
    case "io.fabric8.kubernetes.api.model."+"GenericKubernetesResource": return (VisitableBuilder<T, ?>)new GenericKubernetesResourceBuilder((GenericKubernetesResource) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetStatus": return (VisitableBuilder<T, ?>)new StatefulSetStatusBuilder((StatefulSetStatus) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetOrdinals": return (VisitableBuilder<T, ?>)new StatefulSetOrdinalsBuilder((StatefulSetOrdinals) item);
    case "io.fabric8.kubernetes.api.model.apps."+"RollingUpdateStatefulSetStrategy": return (VisitableBuilder<T, ?>)new RollingUpdateStatefulSetStrategyBuilder((RollingUpdateStatefulSetStrategy) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ReplicaSetCondition": return (VisitableBuilder<T, ?>)new ReplicaSetConditionBuilder((ReplicaSetCondition) item);
    case "io.fabric8.kubernetes.api.model."+"PodTemplateSpec": return (VisitableBuilder<T, ?>)new PodTemplateSpecBuilder((PodTemplateSpec) item);
    case "io.fabric8.kubernetes.api.model."+"LocalObjectReference": return (VisitableBuilder<T, ?>)new LocalObjectReferenceBuilder((LocalObjectReference) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ReplicaSetSpec": return (VisitableBuilder<T, ?>)new ReplicaSetSpecBuilder((ReplicaSetSpec) item);
    case "io.fabric8.kubernetes.api.model."+"ResourceRequirements": return (VisitableBuilder<T, ?>)new ResourceRequirementsBuilder((ResourceRequirements) item);
    case "io.fabric8.kubernetes.api.model.apps."+"RollingUpdateDeployment": return (VisitableBuilder<T, ?>)new RollingUpdateDeploymentBuilder((RollingUpdateDeployment) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ControllerRevisionList": return (VisitableBuilder<T, ?>)new ControllerRevisionListBuilder((ControllerRevisionList) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetList": return (VisitableBuilder<T, ?>)new StatefulSetListBuilder((StatefulSetList) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSet": return (VisitableBuilder<T, ?>)new DaemonSetBuilder((DaemonSet) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DeploymentSpec": return (VisitableBuilder<T, ?>)new DeploymentSpecBuilder((DeploymentSpec) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DeploymentStatus": return (VisitableBuilder<T, ?>)new DeploymentStatusBuilder((DeploymentStatus) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ReplicaSetStatus": return (VisitableBuilder<T, ?>)new ReplicaSetStatusBuilder((ReplicaSetStatus) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ControllerRevision": return (VisitableBuilder<T, ?>)new ControllerRevisionBuilder((ControllerRevision) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DeploymentCondition": return (VisitableBuilder<T, ?>)new DeploymentConditionBuilder((DeploymentCondition) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSetCondition": return (VisitableBuilder<T, ?>)new DaemonSetConditionBuilder((DaemonSetCondition) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetPersistentVolumeClaimRetentionPolicy": return (VisitableBuilder<T, ?>)new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder((StatefulSetPersistentVolumeClaimRetentionPolicy) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSetList": return (VisitableBuilder<T, ?>)new DaemonSetListBuilder((DaemonSetList) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetCondition": return (VisitableBuilder<T, ?>)new StatefulSetConditionBuilder((StatefulSetCondition) item);
    case "io.fabric8.kubernetes.api.model.apps."+"ReplicaSetList": return (VisitableBuilder<T, ?>)new ReplicaSetListBuilder((ReplicaSetList) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectReference": return (VisitableBuilder<T, ?>)new ObjectReferenceBuilder((ObjectReference) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSetStatus": return (VisitableBuilder<T, ?>)new DaemonSetStatusBuilder((DaemonSetStatus) item);
    case "io.fabric8.kubernetes.api.model.runtime."+"RawExtension": return (VisitableBuilder<T, ?>)new RawExtensionBuilder((RawExtension) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSet": return (VisitableBuilder<T, ?>)new StatefulSetBuilder((StatefulSet) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetSpec": return (VisitableBuilder<T, ?>)new StatefulSetSpecBuilder((StatefulSetSpec) item);
    case "io.fabric8.kubernetes.api.model.apps."+"RollingUpdateDaemonSet": return (VisitableBuilder<T, ?>)new RollingUpdateDaemonSetBuilder((RollingUpdateDaemonSet) item);
    case "io.fabric8.kubernetes.api.model."+"ObjectMeta": return (VisitableBuilder<T, ?>)new ObjectMetaBuilder((ObjectMeta) item);
    case "io.fabric8.kubernetes.api.model."+"PersistentVolumeClaim": return (VisitableBuilder<T, ?>)new PersistentVolumeClaimBuilder((PersistentVolumeClaim) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DeploymentStrategy": return (VisitableBuilder<T, ?>)new DeploymentStrategyBuilder((DeploymentStrategy) item);
    case "io.fabric8.kubernetes.api.model.apps."+"DaemonSetSpec": return (VisitableBuilder<T, ?>)new DaemonSetSpecBuilder((DaemonSetSpec) item);
    case "io.fabric8.kubernetes.api.model.apps."+"StatefulSetUpdateStrategy": return (VisitableBuilder<T, ?>)new StatefulSetUpdateStrategyBuilder((StatefulSetUpdateStrategy) item);
    case "io.fabric8.kubernetes.api.model.apps."+"Deployment": return (VisitableBuilder<T, ?>)new DeploymentBuilder((Deployment) item);
    }
     return (VisitableBuilder<T, ?>)builderOf(item);
  }
  public class DeploymentListDataNested<N> extends DeploymentListFluent<DeploymentListDataNested<N>> implements Nested<N>{
    DeploymentListDataNested(DeploymentList item) {
      this.builder = new DeploymentListBuilder(this, item);
    }
    DeploymentListBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentListData() {
      return and();
    }
    
  
  }
  public class DaemonSetUpdateStrategyDataNested<N> extends DaemonSetUpdateStrategyFluent<DaemonSetUpdateStrategyDataNested<N>> implements Nested<N>{
    DaemonSetUpdateStrategyDataNested(DaemonSetUpdateStrategy item) {
      this.builder = new DaemonSetUpdateStrategyBuilder(this, item);
    }
    DaemonSetUpdateStrategyBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetUpdateStrategyData() {
      return and();
    }
    
  
  }
  public class ReplicaSetDataNested<N> extends ReplicaSetFluent<ReplicaSetDataNested<N>> implements Nested<N>{
    ReplicaSetDataNested(ReplicaSet item) {
      this.builder = new ReplicaSetBuilder(this, item);
    }
    ReplicaSetBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endReplicaSetData() {
      return and();
    }
    
  
  }
  public class LabelSelectorDataNested<N> extends LabelSelectorFluent<LabelSelectorDataNested<N>> implements Nested<N>{
    LabelSelectorDataNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endLabelSelectorData() {
      return and();
    }
    
  
  }
  public class ContainerDataNested<N> extends ContainerFluent<ContainerDataNested<N>> implements Nested<N>{
    ContainerDataNested(Container item) {
      this.builder = new ContainerBuilder(this, item);
    }
    ContainerBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endContainerData() {
      return and();
    }
    
  
  }
  public class GenericKubernetesResourceDataNested<N> extends GenericKubernetesResourceFluent<GenericKubernetesResourceDataNested<N>> implements Nested<N>{
    GenericKubernetesResourceDataNested(GenericKubernetesResource item) {
      this.builder = new GenericKubernetesResourceBuilder(this, item);
    }
    GenericKubernetesResourceBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endGenericKubernetesResourceData() {
      return and();
    }
    
  
  }
  public class StatefulSetStatusDataNested<N> extends StatefulSetStatusFluent<StatefulSetStatusDataNested<N>> implements Nested<N>{
    StatefulSetStatusDataNested(StatefulSetStatus item) {
      this.builder = new StatefulSetStatusBuilder(this, item);
    }
    StatefulSetStatusBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetStatusData() {
      return and();
    }
    
  
  }
  public class StatefulSetOrdinalsDataNested<N> extends StatefulSetOrdinalsFluent<StatefulSetOrdinalsDataNested<N>> implements Nested<N>{
    StatefulSetOrdinalsDataNested(StatefulSetOrdinals item) {
      this.builder = new StatefulSetOrdinalsBuilder(this, item);
    }
    StatefulSetOrdinalsBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetOrdinalsData() {
      return and();
    }
    
  
  }
  public class RollingUpdateStatefulSetStrategyDataNested<N> extends RollingUpdateStatefulSetStrategyFluent<RollingUpdateStatefulSetStrategyDataNested<N>> implements Nested<N>{
    RollingUpdateStatefulSetStrategyDataNested(RollingUpdateStatefulSetStrategy item) {
      this.builder = new RollingUpdateStatefulSetStrategyBuilder(this, item);
    }
    RollingUpdateStatefulSetStrategyBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endRollingUpdateStatefulSetStrategyData() {
      return and();
    }
    
  
  }
  public class ReplicaSetConditionDataNested<N> extends ReplicaSetConditionFluent<ReplicaSetConditionDataNested<N>> implements Nested<N>{
    ReplicaSetConditionDataNested(ReplicaSetCondition item) {
      this.builder = new ReplicaSetConditionBuilder(this, item);
    }
    ReplicaSetConditionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endReplicaSetConditionData() {
      return and();
    }
    
  
  }
  public class PodTemplateSpecDataNested<N> extends PodTemplateSpecFluent<PodTemplateSpecDataNested<N>> implements Nested<N>{
    PodTemplateSpecDataNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endPodTemplateSpecData() {
      return and();
    }
    
  
  }
  public class LocalObjectReferenceDataNested<N> extends LocalObjectReferenceFluent<LocalObjectReferenceDataNested<N>> implements Nested<N>{
    LocalObjectReferenceDataNested(LocalObjectReference item) {
      this.builder = new LocalObjectReferenceBuilder(this, item);
    }
    LocalObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endLocalObjectReferenceData() {
      return and();
    }
    
  
  }
  public class ReplicaSetSpecDataNested<N> extends ReplicaSetSpecFluent<ReplicaSetSpecDataNested<N>> implements Nested<N>{
    ReplicaSetSpecDataNested(ReplicaSetSpec item) {
      this.builder = new ReplicaSetSpecBuilder(this, item);
    }
    ReplicaSetSpecBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endReplicaSetSpecData() {
      return and();
    }
    
  
  }
  public class ResourceRequirementsDataNested<N> extends ResourceRequirementsFluent<ResourceRequirementsDataNested<N>> implements Nested<N>{
    ResourceRequirementsDataNested(ResourceRequirements item) {
      this.builder = new ResourceRequirementsBuilder(this, item);
    }
    ResourceRequirementsBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endResourceRequirementsData() {
      return and();
    }
    
  
  }
  public class RollingUpdateDeploymentDataNested<N> extends RollingUpdateDeploymentFluent<RollingUpdateDeploymentDataNested<N>> implements Nested<N>{
    RollingUpdateDeploymentDataNested(RollingUpdateDeployment item) {
      this.builder = new RollingUpdateDeploymentBuilder(this, item);
    }
    RollingUpdateDeploymentBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endRollingUpdateDeploymentData() {
      return and();
    }
    
  
  }
  public class ControllerRevisionListDataNested<N> extends ControllerRevisionListFluent<ControllerRevisionListDataNested<N>> implements Nested<N>{
    ControllerRevisionListDataNested(ControllerRevisionList item) {
      this.builder = new ControllerRevisionListBuilder(this, item);
    }
    ControllerRevisionListBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endControllerRevisionListData() {
      return and();
    }
    
  
  }
  public class StatefulSetListDataNested<N> extends StatefulSetListFluent<StatefulSetListDataNested<N>> implements Nested<N>{
    StatefulSetListDataNested(StatefulSetList item) {
      this.builder = new StatefulSetListBuilder(this, item);
    }
    StatefulSetListBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetListData() {
      return and();
    }
    
  
  }
  public class DaemonSetDataNested<N> extends DaemonSetFluent<DaemonSetDataNested<N>> implements Nested<N>{
    DaemonSetDataNested(DaemonSet item) {
      this.builder = new DaemonSetBuilder(this, item);
    }
    DaemonSetBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetData() {
      return and();
    }
    
  
  }
  public class DeploymentSpecDataNested<N> extends DeploymentSpecFluent<DeploymentSpecDataNested<N>> implements Nested<N>{
    DeploymentSpecDataNested(DeploymentSpec item) {
      this.builder = new DeploymentSpecBuilder(this, item);
    }
    DeploymentSpecBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentSpecData() {
      return and();
    }
    
  
  }
  public class DeploymentStatusDataNested<N> extends DeploymentStatusFluent<DeploymentStatusDataNested<N>> implements Nested<N>{
    DeploymentStatusDataNested(DeploymentStatus item) {
      this.builder = new DeploymentStatusBuilder(this, item);
    }
    DeploymentStatusBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentStatusData() {
      return and();
    }
    
  
  }
  public class ReplicaSetStatusDataNested<N> extends ReplicaSetStatusFluent<ReplicaSetStatusDataNested<N>> implements Nested<N>{
    ReplicaSetStatusDataNested(ReplicaSetStatus item) {
      this.builder = new ReplicaSetStatusBuilder(this, item);
    }
    ReplicaSetStatusBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endReplicaSetStatusData() {
      return and();
    }
    
  
  }
  public class ControllerRevisionDataNested<N> extends ControllerRevisionFluent<ControllerRevisionDataNested<N>> implements Nested<N>{
    ControllerRevisionDataNested(ControllerRevision item) {
      this.builder = new ControllerRevisionBuilder(this, item);
    }
    ControllerRevisionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endControllerRevisionData() {
      return and();
    }
    
  
  }
  public class DeploymentConditionDataNested<N> extends DeploymentConditionFluent<DeploymentConditionDataNested<N>> implements Nested<N>{
    DeploymentConditionDataNested(DeploymentCondition item) {
      this.builder = new DeploymentConditionBuilder(this, item);
    }
    DeploymentConditionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentConditionData() {
      return and();
    }
    
  
  }
  public class DaemonSetConditionDataNested<N> extends DaemonSetConditionFluent<DaemonSetConditionDataNested<N>> implements Nested<N>{
    DaemonSetConditionDataNested(DaemonSetCondition item) {
      this.builder = new DaemonSetConditionBuilder(this, item);
    }
    DaemonSetConditionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetConditionData() {
      return and();
    }
    
  
  }
  public class StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<N> extends StatefulSetPersistentVolumeClaimRetentionPolicyFluent<StatefulSetPersistentVolumeClaimRetentionPolicyDataNested<N>> implements Nested<N>{
    StatefulSetPersistentVolumeClaimRetentionPolicyDataNested(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
    }
    StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetPersistentVolumeClaimRetentionPolicyData() {
      return and();
    }
    
  
  }
  public class DaemonSetListDataNested<N> extends DaemonSetListFluent<DaemonSetListDataNested<N>> implements Nested<N>{
    DaemonSetListDataNested(DaemonSetList item) {
      this.builder = new DaemonSetListBuilder(this, item);
    }
    DaemonSetListBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetListData() {
      return and();
    }
    
  
  }
  public class StatefulSetConditionDataNested<N> extends StatefulSetConditionFluent<StatefulSetConditionDataNested<N>> implements Nested<N>{
    StatefulSetConditionDataNested(StatefulSetCondition item) {
      this.builder = new StatefulSetConditionBuilder(this, item);
    }
    StatefulSetConditionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetConditionData() {
      return and();
    }
    
  
  }
  public class ReplicaSetListDataNested<N> extends ReplicaSetListFluent<ReplicaSetListDataNested<N>> implements Nested<N>{
    ReplicaSetListDataNested(ReplicaSetList item) {
      this.builder = new ReplicaSetListBuilder(this, item);
    }
    ReplicaSetListBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endReplicaSetListData() {
      return and();
    }
    
  
  }
  public class ObjectReferenceDataNested<N> extends ObjectReferenceFluent<ObjectReferenceDataNested<N>> implements Nested<N>{
    ObjectReferenceDataNested(ObjectReference item) {
      this.builder = new ObjectReferenceBuilder(this, item);
    }
    ObjectReferenceBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endObjectReferenceData() {
      return and();
    }
    
  
  }
  public class DaemonSetStatusDataNested<N> extends DaemonSetStatusFluent<DaemonSetStatusDataNested<N>> implements Nested<N>{
    DaemonSetStatusDataNested(DaemonSetStatus item) {
      this.builder = new DaemonSetStatusBuilder(this, item);
    }
    DaemonSetStatusBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetStatusData() {
      return and();
    }
    
  
  }
  public class RawExtensionDataNested<N> extends RawExtensionFluent<RawExtensionDataNested<N>> implements Nested<N>{
    RawExtensionDataNested(RawExtension item) {
      this.builder = new RawExtensionBuilder(this, item);
    }
    RawExtensionBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endRawExtensionData() {
      return and();
    }
    
  
  }
  public class StatefulSetDataNested<N> extends StatefulSetFluent<StatefulSetDataNested<N>> implements Nested<N>{
    StatefulSetDataNested(StatefulSet item) {
      this.builder = new StatefulSetBuilder(this, item);
    }
    StatefulSetBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetData() {
      return and();
    }
    
  
  }
  public class StatefulSetSpecDataNested<N> extends StatefulSetSpecFluent<StatefulSetSpecDataNested<N>> implements Nested<N>{
    StatefulSetSpecDataNested(StatefulSetSpec item) {
      this.builder = new StatefulSetSpecBuilder(this, item);
    }
    StatefulSetSpecBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetSpecData() {
      return and();
    }
    
  
  }
  public class RollingUpdateDaemonSetDataNested<N> extends RollingUpdateDaemonSetFluent<RollingUpdateDaemonSetDataNested<N>> implements Nested<N>{
    RollingUpdateDaemonSetDataNested(RollingUpdateDaemonSet item) {
      this.builder = new RollingUpdateDaemonSetBuilder(this, item);
    }
    RollingUpdateDaemonSetBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endRollingUpdateDaemonSetData() {
      return and();
    }
    
  
  }
  public class ObjectMetaDataNested<N> extends ObjectMetaFluent<ObjectMetaDataNested<N>> implements Nested<N>{
    ObjectMetaDataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endObjectMetaData() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimDataNested<N> extends PersistentVolumeClaimFluent<PersistentVolumeClaimDataNested<N>> implements Nested<N>{
    PersistentVolumeClaimDataNested(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endPersistentVolumeClaimData() {
      return and();
    }
    
  
  }
  public class DeploymentStrategyDataNested<N> extends DeploymentStrategyFluent<DeploymentStrategyDataNested<N>> implements Nested<N>{
    DeploymentStrategyDataNested(DeploymentStrategy item) {
      this.builder = new DeploymentStrategyBuilder(this, item);
    }
    DeploymentStrategyBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentStrategyData() {
      return and();
    }
    
  
  }
  public class DaemonSetSpecDataNested<N> extends DaemonSetSpecFluent<DaemonSetSpecDataNested<N>> implements Nested<N>{
    DaemonSetSpecDataNested(DaemonSetSpec item) {
      this.builder = new DaemonSetSpecBuilder(this, item);
    }
    DaemonSetSpecBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDaemonSetSpecData() {
      return and();
    }
    
  
  }
  public class StatefulSetUpdateStrategyDataNested<N> extends StatefulSetUpdateStrategyFluent<StatefulSetUpdateStrategyDataNested<N>> implements Nested<N>{
    StatefulSetUpdateStrategyDataNested(StatefulSetUpdateStrategy item) {
      this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
    }
    StatefulSetUpdateStrategyBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endStatefulSetUpdateStrategyData() {
      return and();
    }
    
  
  }
  public class DeploymentDataNested<N> extends DeploymentFluent<DeploymentDataNested<N>> implements Nested<N>{
    DeploymentDataNested(Deployment item) {
      this.builder = new DeploymentBuilder(this, item);
    }
    DeploymentBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withData(builder.build());
    }
    
    public N endDeploymentData() {
      return and();
    }
    
  
  }
  public class MetadataNested<N> extends ObjectMetaFluent<MetadataNested<N>> implements Nested<N>{
    MetadataNested(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    ObjectMetaBuilder builder;
    
    public N and() {
      return (N) ControllerRevisionFluent.this.withMetadata(builder.build());
    }
    
    public N endMetadata() {
      return and();
    }
    
  
  }

}