package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class StatefulSetSpecFluent<A extends StatefulSetSpecFluent<A>> extends BaseFluent<A>{
  public StatefulSetSpecFluent() {
  }
  
  public StatefulSetSpecFluent(StatefulSetSpec instance) {
    this.copyInstance(instance);
  }
  private Integer minReadySeconds;
  private StatefulSetOrdinalsBuilder ordinals;
  private StatefulSetPersistentVolumeClaimRetentionPolicyBuilder persistentVolumeClaimRetentionPolicy;
  private String podManagementPolicy;
  private Integer replicas;
  private Integer revisionHistoryLimit;
  private LabelSelectorBuilder selector;
  private String serviceName;
  private PodTemplateSpecBuilder template;
  private StatefulSetUpdateStrategyBuilder updateStrategy;
  private ArrayList<PersistentVolumeClaimBuilder> volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(StatefulSetSpec instance) {
    instance = (instance != null ? instance : new StatefulSetSpec());
    if (instance != null) {
          this.withMinReadySeconds(instance.getMinReadySeconds());
          this.withOrdinals(instance.getOrdinals());
          this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
          this.withPodManagementPolicy(instance.getPodManagementPolicy());
          this.withReplicas(instance.getReplicas());
          this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
          this.withSelector(instance.getSelector());
          this.withServiceName(instance.getServiceName());
          this.withTemplate(instance.getTemplate());
          this.withUpdateStrategy(instance.getUpdateStrategy());
          this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
          this.withMinReadySeconds(instance.getMinReadySeconds());
          this.withOrdinals(instance.getOrdinals());
          this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
          this.withPodManagementPolicy(instance.getPodManagementPolicy());
          this.withReplicas(instance.getReplicas());
          this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
          this.withSelector(instance.getSelector());
          this.withServiceName(instance.getServiceName());
          this.withTemplate(instance.getTemplate());
          this.withUpdateStrategy(instance.getUpdateStrategy());
          this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds = minReadySeconds;
    return (A) this;
  }
  
  public boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  
  public StatefulSetOrdinals buildOrdinals() {
    return this.ordinals != null ? this.ordinals.build() : null;
  }
  
  public A withOrdinals(StatefulSetOrdinals ordinals) {
    this._visitables.remove(this.ordinals);
    if (ordinals != null) {
        this.ordinals = new StatefulSetOrdinalsBuilder(ordinals);
        this._visitables.get("ordinals").add(this.ordinals);
    } else {
        this.ordinals = null;
        this._visitables.get("ordinals").remove(this.ordinals);
    }
    return (A) this;
  }
  
  public boolean hasOrdinals() {
    return this.ordinals != null;
  }
  
  public A withNewOrdinals(Integer start) {
    return (A)withOrdinals(new StatefulSetOrdinals(start));
  }
  
  public OrdinalsNested<A> withNewOrdinals() {
    return new OrdinalsNested(null);
  }
  
  public OrdinalsNested<A> withNewOrdinalsLike(StatefulSetOrdinals item) {
    return new OrdinalsNested(item);
  }
  
  public OrdinalsNested<A> editOrdinals() {
    return withNewOrdinalsLike(java.util.Optional.ofNullable(buildOrdinals()).orElse(null));
  }
  
  public OrdinalsNested<A> editOrNewOrdinals() {
    return withNewOrdinalsLike(java.util.Optional.ofNullable(buildOrdinals()).orElse(new StatefulSetOrdinalsBuilder().build()));
  }
  
  public OrdinalsNested<A> editOrNewOrdinalsLike(StatefulSetOrdinals item) {
    return withNewOrdinalsLike(java.util.Optional.ofNullable(buildOrdinals()).orElse(item));
  }
  
  public StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy() {
    return this.persistentVolumeClaimRetentionPolicy != null ? this.persistentVolumeClaimRetentionPolicy.build() : null;
  }
  
  public A withPersistentVolumeClaimRetentionPolicy(StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
    this._visitables.remove(this.persistentVolumeClaimRetentionPolicy);
    if (persistentVolumeClaimRetentionPolicy != null) {
        this.persistentVolumeClaimRetentionPolicy = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(persistentVolumeClaimRetentionPolicy);
        this._visitables.get("persistentVolumeClaimRetentionPolicy").add(this.persistentVolumeClaimRetentionPolicy);
    } else {
        this.persistentVolumeClaimRetentionPolicy = null;
        this._visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
    }
    return (A) this;
  }
  
  public boolean hasPersistentVolumeClaimRetentionPolicy() {
    return this.persistentVolumeClaimRetentionPolicy != null;
  }
  
  public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted,String whenScaled) {
    return (A)withPersistentVolumeClaimRetentionPolicy(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
  }
  
  public PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy() {
    return new PersistentVolumeClaimRetentionPolicyNested(null);
  }
  
  public PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return new PersistentVolumeClaimRetentionPolicyNested(item);
  }
  
  public PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy() {
    return withNewPersistentVolumeClaimRetentionPolicyLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimRetentionPolicy()).orElse(null));
  }
  
  public PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy() {
    return withNewPersistentVolumeClaimRetentionPolicyLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimRetentionPolicy()).orElse(new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder().build()));
  }
  
  public PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return withNewPersistentVolumeClaimRetentionPolicyLike(java.util.Optional.ofNullable(buildPersistentVolumeClaimRetentionPolicy()).orElse(item));
  }
  
  public String getPodManagementPolicy() {
    return this.podManagementPolicy;
  }
  
  public A withPodManagementPolicy(String podManagementPolicy) {
    this.podManagementPolicy = podManagementPolicy;
    return (A) this;
  }
  
  public boolean hasPodManagementPolicy() {
    return this.podManagementPolicy != null;
  }
  
  public Integer getReplicas() {
    return this.replicas;
  }
  
  public A withReplicas(Integer replicas) {
    this.replicas = replicas;
    return (A) this;
  }
  
  public boolean hasReplicas() {
    return this.replicas != null;
  }
  
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit = revisionHistoryLimit;
    return (A) this;
  }
  
  public boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public String getServiceName() {
    return this.serviceName;
  }
  
  public A withServiceName(String serviceName) {
    this.serviceName = serviceName;
    return (A) this;
  }
  
  public boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  public PodTemplateSpec buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(PodTemplateSpec template) {
    this._visitables.remove(this.template);
    if (template != null) {
        this.template = new PodTemplateSpecBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public StatefulSetUpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy != null ? this.updateStrategy.build() : null;
  }
  
  public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy) {
    this._visitables.remove(this.updateStrategy);
    if (updateStrategy != null) {
        this.updateStrategy = new StatefulSetUpdateStrategyBuilder(updateStrategy);
        this._visitables.get("updateStrategy").add(this.updateStrategy);
    } else {
        this.updateStrategy = null;
        this._visitables.get("updateStrategy").remove(this.updateStrategy);
    }
    return (A) this;
  }
  
  public boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  
  public UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new UpdateStrategyNested(null);
  }
  
  public UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
    return new UpdateStrategyNested(item);
  }
  
  public UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(null));
  }
  
  public UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(new StatefulSetUpdateStrategyBuilder().build()));
  }
  
  public UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
    return withNewUpdateStrategyLike(java.util.Optional.ofNullable(buildUpdateStrategy()).orElse(item));
  }
  
  public A addToVolumeClaimTemplates(int index,PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= volumeClaimTemplates.size()) { _visitables.get("volumeClaimTemplates").add(builder); volumeClaimTemplates.add(builder); } else { _visitables.get("volumeClaimTemplates").add(index, builder); volumeClaimTemplates.add(index, builder);}
    return (A)this;
  }
  
  public A setToVolumeClaimTemplates(int index,PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= volumeClaimTemplates.size()) { _visitables.get("volumeClaimTemplates").add(builder); volumeClaimTemplates.add(builder); } else { _visitables.get("volumeClaimTemplates").set(index, builder); volumeClaimTemplates.set(index, builder);}
    return (A)this;
  }
  
  public A addToVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  
  public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  
  public A removeFromVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.volumeClaimTemplates == null) return (A)this;
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder); this.volumeClaimTemplates.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
    if (this.volumeClaimTemplates == null) return (A)this;
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder); this.volumeClaimTemplates.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate) {
    if (volumeClaimTemplates == null) return (A) this;
    final Iterator<PersistentVolumeClaimBuilder> each = volumeClaimTemplates.iterator();
    final List visitables = _visitables.get("volumeClaimTemplates");
    while (each.hasNext()) {
      PersistentVolumeClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<PersistentVolumeClaim> buildVolumeClaimTemplates() {
    return this.volumeClaimTemplates != null ? build(volumeClaimTemplates) : null;
  }
  
  public PersistentVolumeClaim buildVolumeClaimTemplate(int index) {
    return this.volumeClaimTemplates.get(index).build();
  }
  
  public PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(0).build();
  }
  
  public PersistentVolumeClaim buildLastVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(volumeClaimTemplates.size() - 1).build();
  }
  
  public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
      for (PersistentVolumeClaimBuilder item : volumeClaimTemplates) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
      for (PersistentVolumeClaimBuilder item : volumeClaimTemplates) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) {
      this._visitables.get("volumeClaimTemplates").clear();
    }
    if (volumeClaimTemplates != null) {
        this.volumeClaimTemplates = new ArrayList();
        for (PersistentVolumeClaim item : volumeClaimTemplates) {
          this.addToVolumeClaimTemplates(item);
        }
    } else {
      this.volumeClaimTemplates = null;
    }
    return (A) this;
  }
  
  public A withVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.clear(); _visitables.remove("volumeClaimTemplates"); }
    if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
  }
  
  public boolean hasVolumeClaimTemplates() {
    return this.volumeClaimTemplates != null && !this.volumeClaimTemplates.isEmpty();
  }
  
  public VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
    return new VolumeClaimTemplatesNested(-1, null);
  }
  
  public VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
    return new VolumeClaimTemplatesNested(-1, item);
  }
  
  public VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,PersistentVolumeClaim item) {
    return new VolumeClaimTemplatesNested(index, item);
  }
  
  public VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index) {
    if (volumeClaimTemplates.size() <= index) throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  
  public VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
    if (volumeClaimTemplates.size() == 0) throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(0, buildVolumeClaimTemplate(0));
  }
  
  public VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
    int index = volumeClaimTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  
  public VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeClaimTemplates.size();i++) { 
    if (predicate.test(volumeClaimTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    StatefulSetSpecFluent that = (StatefulSetSpecFluent) o;
    if (!java.util.Objects.equals(minReadySeconds, that.minReadySeconds)) return false;
    if (!java.util.Objects.equals(ordinals, that.ordinals)) return false;
    if (!java.util.Objects.equals(persistentVolumeClaimRetentionPolicy, that.persistentVolumeClaimRetentionPolicy)) return false;
    if (!java.util.Objects.equals(podManagementPolicy, that.podManagementPolicy)) return false;
    if (!java.util.Objects.equals(replicas, that.replicas)) return false;
    if (!java.util.Objects.equals(revisionHistoryLimit, that.revisionHistoryLimit)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(serviceName, that.serviceName)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(updateStrategy, that.updateStrategy)) return false;
    if (!java.util.Objects.equals(volumeClaimTemplates, that.volumeClaimTemplates)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  ordinals,  persistentVolumeClaimRetentionPolicy,  podManagementPolicy,  replicas,  revisionHistoryLimit,  selector,  serviceName,  template,  updateStrategy,  volumeClaimTemplates,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (ordinals != null) { sb.append("ordinals:"); sb.append(ordinals + ","); }
    if (persistentVolumeClaimRetentionPolicy != null) { sb.append("persistentVolumeClaimRetentionPolicy:"); sb.append(persistentVolumeClaimRetentionPolicy + ","); }
    if (podManagementPolicy != null) { sb.append("podManagementPolicy:"); sb.append(podManagementPolicy + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (updateStrategy != null) { sb.append("updateStrategy:"); sb.append(updateStrategy + ","); }
    if (volumeClaimTemplates != null && !volumeClaimTemplates.isEmpty()) { sb.append("volumeClaimTemplates:"); sb.append(volumeClaimTemplates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class OrdinalsNested<N> extends StatefulSetOrdinalsFluent<OrdinalsNested<N>> implements Nested<N>{
    OrdinalsNested(StatefulSetOrdinals item) {
      this.builder = new StatefulSetOrdinalsBuilder(this, item);
    }
    StatefulSetOrdinalsBuilder builder;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.withOrdinals(builder.build());
    }
    
    public N endOrdinals() {
      return and();
    }
    
  
  }
  public class PersistentVolumeClaimRetentionPolicyNested<N> extends StatefulSetPersistentVolumeClaimRetentionPolicyFluent<PersistentVolumeClaimRetentionPolicyNested<N>> implements Nested<N>{
    PersistentVolumeClaimRetentionPolicyNested(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
    }
    StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.withPersistentVolumeClaimRetentionPolicy(builder.build());
    }
    
    public N endPersistentVolumeClaimRetentionPolicy() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }
  public class UpdateStrategyNested<N> extends StatefulSetUpdateStrategyFluent<UpdateStrategyNested<N>> implements Nested<N>{
    UpdateStrategyNested(StatefulSetUpdateStrategy item) {
      this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
    }
    StatefulSetUpdateStrategyBuilder builder;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.withUpdateStrategy(builder.build());
    }
    
    public N endUpdateStrategy() {
      return and();
    }
    
  
  }
  public class VolumeClaimTemplatesNested<N> extends PersistentVolumeClaimFluent<VolumeClaimTemplatesNested<N>> implements Nested<N>{
    VolumeClaimTemplatesNested(int index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimBuilder builder;
    int index;
    
    public N and() {
      return (N) StatefulSetSpecFluent.this.setToVolumeClaimTemplates(index,builder.build());
    }
    
    public N endVolumeClaimTemplate() {
      return and();
    }
    
  
  }

}