package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetSpecBuilder extends StatefulSetSpecFluent<StatefulSetSpecBuilder> implements VisitableBuilder<StatefulSetSpec,StatefulSetSpecBuilder>{
  public StatefulSetSpecBuilder() {
    this(false);
  }
  public StatefulSetSpecBuilder(Boolean validationEnabled) {
    this(new StatefulSetSpec(), validationEnabled);
  }
  public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetSpec(), validationEnabled);
  }
  public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,StatefulSetSpec instance) {
    this(fluent, instance, false);
  }
  public StatefulSetSpecBuilder(StatefulSetSpecFluent<?> fluent,StatefulSetSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new StatefulSetSpec());

    if (instance != null) {
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withOrdinals(instance.getOrdinals());
      fluent.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
      fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
      fluent.withReplicas(instance.getReplicas());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withServiceName(instance.getServiceName());
      fluent.withTemplate(instance.getTemplate());
      fluent.withUpdateStrategy(instance.getUpdateStrategy());
      fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
      fluent.withMinReadySeconds(instance.getMinReadySeconds());
      fluent.withOrdinals(instance.getOrdinals());
      fluent.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
      fluent.withPodManagementPolicy(instance.getPodManagementPolicy());
      fluent.withReplicas(instance.getReplicas());
      fluent.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      fluent.withSelector(instance.getSelector());
      fluent.withServiceName(instance.getServiceName());
      fluent.withTemplate(instance.getTemplate());
      fluent.withUpdateStrategy(instance.getUpdateStrategy());
      fluent.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetSpecBuilder(StatefulSetSpec instance) {
    this(instance,false);
  }
  public StatefulSetSpecBuilder(StatefulSetSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new StatefulSetSpec());

    if (instance != null) {
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withOrdinals(instance.getOrdinals());
      this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
      this.withPodManagementPolicy(instance.getPodManagementPolicy());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withServiceName(instance.getServiceName());
      this.withTemplate(instance.getTemplate());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
      this.withMinReadySeconds(instance.getMinReadySeconds());
      this.withOrdinals(instance.getOrdinals());
      this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy());
      this.withPodManagementPolicy(instance.getPodManagementPolicy());
      this.withReplicas(instance.getReplicas());
      this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit());
      this.withSelector(instance.getSelector());
      this.withServiceName(instance.getServiceName());
      this.withTemplate(instance.getTemplate());
      this.withUpdateStrategy(instance.getUpdateStrategy());
      this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatefulSetSpecFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetSpec build() {
    StatefulSetSpec buildable = new StatefulSetSpec(fluent.getMinReadySeconds(),fluent.buildOrdinals(),fluent.buildPersistentVolumeClaimRetentionPolicy(),fluent.getPodManagementPolicy(),fluent.getReplicas(),fluent.getRevisionHistoryLimit(),fluent.buildSelector(),fluent.getServiceName(),fluent.buildTemplate(),fluent.buildUpdateStrategy(),fluent.buildVolumeClaimTemplates());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}