package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentBuilder extends DeploymentFluent<DeploymentBuilder> implements VisitableBuilder<Deployment,DeploymentBuilder>{
  public DeploymentBuilder() {
    this(false);
  }
  public DeploymentBuilder(Boolean validationEnabled) {
    this(new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Deployment(), validationEnabled);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Deployment instance) {
    this(fluent, instance, false);
  }
  public DeploymentBuilder(DeploymentFluent<?> fluent,Deployment instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new Deployment());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentBuilder(Deployment instance) {
    this(instance,false);
  }
  public DeploymentBuilder(Deployment instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new Deployment());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentFluent<?> fluent;
  Boolean validationEnabled;
  public Deployment build() {
    Deployment buildable = new Deployment(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}