package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class DeploymentStatusBuilder extends DeploymentStatusFluentImpl<DeploymentStatusBuilder> implements VisitableBuilder<DeploymentStatus,DeploymentStatusBuilder>{
  public DeploymentStatusBuilder() {
    this(false);
  }
  public DeploymentStatusBuilder(Boolean validationEnabled) {
    this(new DeploymentStatus(), validationEnabled);
  }
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new DeploymentStatus(), validationEnabled);
  }
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent,DeploymentStatus instance) {
    this(fluent, instance, false);
  }
  public DeploymentStatusBuilder(DeploymentStatusFluent<?> fluent,DeploymentStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAvailableReplicas(instance.getAvailableReplicas());
      fluent.withCollisionCount(instance.getCollisionCount());
      fluent.withConditions(instance.getConditions());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withReadyReplicas(instance.getReadyReplicas());
      fluent.withReplicas(instance.getReplicas());
      fluent.withUnavailableReplicas(instance.getUnavailableReplicas());
      fluent.withUpdatedReplicas(instance.getUpdatedReplicas());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public DeploymentStatusBuilder(DeploymentStatus instance) {
    this(instance,false);
  }
  public DeploymentStatusBuilder(DeploymentStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAvailableReplicas(instance.getAvailableReplicas());
      this.withCollisionCount(instance.getCollisionCount());
      this.withConditions(instance.getConditions());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withReadyReplicas(instance.getReadyReplicas());
      this.withReplicas(instance.getReplicas());
      this.withUnavailableReplicas(instance.getUnavailableReplicas());
      this.withUpdatedReplicas(instance.getUpdatedReplicas());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  DeploymentStatusFluent<?> fluent;
  Boolean validationEnabled;
  public DeploymentStatus build() {
    DeploymentStatus buildable = new DeploymentStatus(fluent.getAvailableReplicas(),fluent.getCollisionCount(),fluent.getConditions(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas(),fluent.getUnavailableReplicas(),fluent.getUpdatedReplicas());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}