package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetUpdateStrategyBuilder extends StatefulSetUpdateStrategyFluentImpl<StatefulSetUpdateStrategyBuilder> implements VisitableBuilder<StatefulSetUpdateStrategy,StatefulSetUpdateStrategyBuilder>{
  public StatefulSetUpdateStrategyBuilder() {
    this(false);
  }
  public StatefulSetUpdateStrategyBuilder(Boolean validationEnabled) {
    this(new StatefulSetUpdateStrategy(), validationEnabled);
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetUpdateStrategy(), validationEnabled);
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent,StatefulSetUpdateStrategy instance) {
    this(fluent, instance, false);
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategyFluent<?> fluent,StatefulSetUpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withRollingUpdate(instance.getRollingUpdate());
      fluent.withType(instance.getType());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategy instance) {
    this(instance,false);
  }
  public StatefulSetUpdateStrategyBuilder(StatefulSetUpdateStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withRollingUpdate(instance.getRollingUpdate());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatefulSetUpdateStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetUpdateStrategy build() {
    StatefulSetUpdateStrategy buildable = new StatefulSetUpdateStrategy(fluent.getRollingUpdate(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}