package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class StatefulSetOrdinalsBuilder extends StatefulSetOrdinalsFluentImpl<StatefulSetOrdinalsBuilder> implements VisitableBuilder<StatefulSetOrdinals,StatefulSetOrdinalsBuilder>{
  public StatefulSetOrdinalsBuilder() {
    this(false);
  }
  public StatefulSetOrdinalsBuilder(Boolean validationEnabled) {
    this(new StatefulSetOrdinals(), validationEnabled);
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinalsFluent<?> fluent) {
    this(fluent, false);
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinalsFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new StatefulSetOrdinals(), validationEnabled);
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinalsFluent<?> fluent,StatefulSetOrdinals instance) {
    this(fluent, instance, false);
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinalsFluent<?> fluent,StatefulSetOrdinals instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withStart(instance.getStart());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinals instance) {
    this(instance,false);
  }
  public StatefulSetOrdinalsBuilder(StatefulSetOrdinals instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withStart(instance.getStart());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  StatefulSetOrdinalsFluent<?> fluent;
  Boolean validationEnabled;
  public StatefulSetOrdinals build() {
    StatefulSetOrdinals buildable = new StatefulSetOrdinals(fluent.getStart());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}