package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RollingUpdateStatefulSetStrategyBuilder extends RollingUpdateStatefulSetStrategyFluentImpl<RollingUpdateStatefulSetStrategyBuilder> implements VisitableBuilder<RollingUpdateStatefulSetStrategy,RollingUpdateStatefulSetStrategyBuilder>{
  public RollingUpdateStatefulSetStrategyBuilder() {
    this(false);
  }
  public RollingUpdateStatefulSetStrategyBuilder(Boolean validationEnabled) {
    this(new RollingUpdateStatefulSetStrategy(), validationEnabled);
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategyFluent<?> fluent) {
    this(fluent, false);
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new RollingUpdateStatefulSetStrategy(), validationEnabled);
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategyFluent<?> fluent,RollingUpdateStatefulSetStrategy instance) {
    this(fluent, instance, false);
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategyFluent<?> fluent,RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMaxUnavailable(instance.getMaxUnavailable()); 
    fluent.withPartition(instance.getPartition()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategy instance) {
    this(instance,false);
  }
  public RollingUpdateStatefulSetStrategyBuilder(RollingUpdateStatefulSetStrategy instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withMaxUnavailable(instance.getMaxUnavailable()); 
    this.withPartition(instance.getPartition()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RollingUpdateStatefulSetStrategyFluent<?> fluent;
  Boolean validationEnabled;
  public RollingUpdateStatefulSetStrategy build() {
    RollingUpdateStatefulSetStrategy buildable = new RollingUpdateStatefulSetStrategy(fluent.getMaxUnavailable(),fluent.getPartition());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}