package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ControllerRevisionFluentImpl<A extends ControllerRevisionFluent<A>> extends BaseFluent<A> implements ControllerRevisionFluent<A>{
  public ControllerRevisionFluentImpl() {
  }
  public ControllerRevisionFluentImpl(ControllerRevision instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withData(instance.getData()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withRevision(instance.getRevision()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String apiVersion;
  private VisitableBuilder<? extends HasMetadata,?> data;
  private String kind;
  private ObjectMetaBuilder metadata;
  private Long revision;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  
  /**
   * This method has been deprecated, please use method buildData instead.
   * @return The buildable object.
   */
  @Deprecated
  public HasMetadata getData() {
    return this.data!=null?this.data.build():null;
  }
  public HasMetadata buildData() {
    return this.data!=null?this.data.build():null;
  }
  public A withData(HasMetadata data) {
    if (data instanceof ReplicaSet){ this.data= new ReplicaSetBuilder((ReplicaSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof DaemonSet){ this.data= new DaemonSetBuilder((DaemonSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof ControllerRevision){ this.data= new ControllerRevisionBuilder((ControllerRevision)data); _visitables.get("data").add(this.data);}
    if (data instanceof StatefulSet){ this.data= new StatefulSetBuilder((StatefulSet)data); _visitables.get("data").add(this.data);}
    if (data instanceof PersistentVolumeClaim){ this.data= new PersistentVolumeClaimBuilder((PersistentVolumeClaim)data); _visitables.get("data").add(this.data);}
    if (data instanceof Deployment){ this.data= new DeploymentBuilder((Deployment)data); _visitables.get("data").add(this.data);}
    return (A) this;
  }
  public Boolean hasData() {
    return this.data != null;
  }
  public A withReplicaSetData(ReplicaSet replicaSetData) {
    _visitables.get("data").remove(this.data);
    if (replicaSetData!=null){ this.data= new ReplicaSetBuilder(replicaSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetData() {
    return new ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl();
  }
  public ControllerRevisionFluent.ReplicaSetDataNested<A> withNewReplicaSetDataLike(ReplicaSet item) {
    return new ControllerRevisionFluentImpl.ReplicaSetDataNestedImpl(item);
  }
  public A withDaemonSetData(DaemonSet daemonSetData) {
    _visitables.get("data").remove(this.data);
    if (daemonSetData!=null){ this.data= new DaemonSetBuilder(daemonSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetData() {
    return new ControllerRevisionFluentImpl.DaemonSetDataNestedImpl();
  }
  public ControllerRevisionFluent.DaemonSetDataNested<A> withNewDaemonSetDataLike(DaemonSet item) {
    return new ControllerRevisionFluentImpl.DaemonSetDataNestedImpl(item);
  }
  public A withControllerRevisionData(ControllerRevision controllerRevisionData) {
    _visitables.get("data").remove(this.data);
    if (controllerRevisionData!=null){ this.data= new ControllerRevisionBuilder(controllerRevisionData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionData() {
    return new ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl();
  }
  public ControllerRevisionFluent.ControllerRevisionDataNested<A> withNewControllerRevisionDataLike(ControllerRevision item) {
    return new ControllerRevisionFluentImpl.ControllerRevisionDataNestedImpl(item);
  }
  public A withStatefulSetData(StatefulSet statefulSetData) {
    _visitables.get("data").remove(this.data);
    if (statefulSetData!=null){ this.data= new StatefulSetBuilder(statefulSetData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetData() {
    return new ControllerRevisionFluentImpl.StatefulSetDataNestedImpl();
  }
  public ControllerRevisionFluent.StatefulSetDataNested<A> withNewStatefulSetDataLike(StatefulSet item) {
    return new ControllerRevisionFluentImpl.StatefulSetDataNestedImpl(item);
  }
  public A withPersistentVolumeClaimData(PersistentVolumeClaim persistentVolumeClaimData) {
    _visitables.get("data").remove(this.data);
    if (persistentVolumeClaimData!=null){ this.data= new PersistentVolumeClaimBuilder(persistentVolumeClaimData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimData() {
    return new ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl();
  }
  public ControllerRevisionFluent.PersistentVolumeClaimDataNested<A> withNewPersistentVolumeClaimDataLike(PersistentVolumeClaim item) {
    return new ControllerRevisionFluentImpl.PersistentVolumeClaimDataNestedImpl(item);
  }
  public A withDeploymentData(Deployment deploymentData) {
    _visitables.get("data").remove(this.data);
    if (deploymentData!=null){ this.data= new DeploymentBuilder(deploymentData); _visitables.get("data").add(this.data);} else { this.data = null; _visitables.get("data").remove(this.data); } return (A) this;
  }
  public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentData() {
    return new ControllerRevisionFluentImpl.DeploymentDataNestedImpl();
  }
  public ControllerRevisionFluent.DeploymentDataNested<A> withNewDeploymentDataLike(Deployment item) {
    return new ControllerRevisionFluentImpl.DeploymentDataNestedImpl(item);
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public ControllerRevisionFluent.MetadataNested<A> withNewMetadata() {
    return new ControllerRevisionFluentImpl.MetadataNestedImpl();
  }
  public ControllerRevisionFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new ControllerRevisionFluentImpl.MetadataNestedImpl(item);
  }
  public ControllerRevisionFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public ControllerRevisionFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  public Long getRevision() {
    return this.revision;
  }
  public A withRevision(Long revision) {
    this.revision=revision; return (A) this;
  }
  public Boolean hasRevision() {
    return this.revision != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ControllerRevisionFluentImpl that = (ControllerRevisionFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (data != null ? !data.equals(that.data) :that.data != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (revision != null ? !revision.equals(that.revision) :that.revision != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  data,  kind,  metadata,  revision,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (data != null) { sb.append("data:"); sb.append(data + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (revision != null) { sb.append("revision:"); sb.append(revision + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ReplicaSetDataNestedImpl<N> extends ReplicaSetFluentImpl<ControllerRevisionFluent.ReplicaSetDataNested<N>> implements ControllerRevisionFluent.ReplicaSetDataNested<N>,Nested<N>{
    ReplicaSetDataNestedImpl(ReplicaSet item) {
      this.builder = new ReplicaSetBuilder(this, item);
    }
    ReplicaSetDataNestedImpl() {
      this.builder = new ReplicaSetBuilder(this);
    }
    ReplicaSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endReplicaSetData() {
      return and();
    }
    
  }
  class DaemonSetDataNestedImpl<N> extends DaemonSetFluentImpl<ControllerRevisionFluent.DaemonSetDataNested<N>> implements ControllerRevisionFluent.DaemonSetDataNested<N>,Nested<N>{
    DaemonSetDataNestedImpl(DaemonSet item) {
      this.builder = new DaemonSetBuilder(this, item);
    }
    DaemonSetDataNestedImpl() {
      this.builder = new DaemonSetBuilder(this);
    }
    DaemonSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDaemonSetData() {
      return and();
    }
    
  }
  class ControllerRevisionDataNestedImpl<N> extends ControllerRevisionFluentImpl<ControllerRevisionFluent.ControllerRevisionDataNested<N>> implements ControllerRevisionFluent.ControllerRevisionDataNested<N>,Nested<N>{
    ControllerRevisionDataNestedImpl(ControllerRevision item) {
      this.builder = new ControllerRevisionBuilder(this, item);
    }
    ControllerRevisionDataNestedImpl() {
      this.builder = new ControllerRevisionBuilder(this);
    }
    ControllerRevisionBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endControllerRevisionData() {
      return and();
    }
    
  }
  class StatefulSetDataNestedImpl<N> extends StatefulSetFluentImpl<ControllerRevisionFluent.StatefulSetDataNested<N>> implements ControllerRevisionFluent.StatefulSetDataNested<N>,Nested<N>{
    StatefulSetDataNestedImpl(StatefulSet item) {
      this.builder = new StatefulSetBuilder(this, item);
    }
    StatefulSetDataNestedImpl() {
      this.builder = new StatefulSetBuilder(this);
    }
    StatefulSetBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endStatefulSetData() {
      return and();
    }
    
  }
  class PersistentVolumeClaimDataNestedImpl<N> extends PersistentVolumeClaimFluentImpl<ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>> implements ControllerRevisionFluent.PersistentVolumeClaimDataNested<N>,Nested<N>{
    PersistentVolumeClaimDataNestedImpl(PersistentVolumeClaim item) {
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    PersistentVolumeClaimDataNestedImpl() {
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endPersistentVolumeClaimData() {
      return and();
    }
    
  }
  class DeploymentDataNestedImpl<N> extends DeploymentFluentImpl<ControllerRevisionFluent.DeploymentDataNested<N>> implements ControllerRevisionFluent.DeploymentDataNested<N>,Nested<N>{
    DeploymentDataNestedImpl(Deployment item) {
      this.builder = new DeploymentBuilder(this, item);
    }
    DeploymentDataNestedImpl() {
      this.builder = new DeploymentBuilder(this);
    }
    DeploymentBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withData(builder.build());
    }
    public N endDeploymentData() {
      return and();
    }
    
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ControllerRevisionFluent.MetadataNested<N>> implements ControllerRevisionFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) ControllerRevisionFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  
}