package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class StatefulSetSpecFluentImpl<A extends StatefulSetSpecFluent<A>> extends BaseFluent<A> implements StatefulSetSpecFluent<A>{
  public StatefulSetSpecFluentImpl() {
  }
  public StatefulSetSpecFluentImpl(StatefulSetSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPersistentVolumeClaimRetentionPolicy(instance.getPersistentVolumeClaimRetentionPolicy()); 
    this.withPodManagementPolicy(instance.getPodManagementPolicy()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withServiceName(instance.getServiceName()); 
    this.withTemplate(instance.getTemplate()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer minReadySeconds;
  private StatefulSetPersistentVolumeClaimRetentionPolicyBuilder persistentVolumeClaimRetentionPolicy;
  private String podManagementPolicy;
  private Integer replicas;
  private Integer revisionHistoryLimit;
  private LabelSelectorBuilder selector;
  private String serviceName;
  private PodTemplateSpecBuilder template;
  private StatefulSetUpdateStrategyBuilder updateStrategy;
  private ArrayList<PersistentVolumeClaimBuilder> volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();
  private Map<String,Object> additionalProperties;
  public Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  
  /**
   * This method has been deprecated, please use method buildPersistentVolumeClaimRetentionPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public StatefulSetPersistentVolumeClaimRetentionPolicy getPersistentVolumeClaimRetentionPolicy() {
    return this.persistentVolumeClaimRetentionPolicy!=null ?this.persistentVolumeClaimRetentionPolicy.build():null;
  }
  public StatefulSetPersistentVolumeClaimRetentionPolicy buildPersistentVolumeClaimRetentionPolicy() {
    return this.persistentVolumeClaimRetentionPolicy!=null ?this.persistentVolumeClaimRetentionPolicy.build():null;
  }
  public A withPersistentVolumeClaimRetentionPolicy(StatefulSetPersistentVolumeClaimRetentionPolicy persistentVolumeClaimRetentionPolicy) {
    _visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy);
    if (persistentVolumeClaimRetentionPolicy!=null){ this.persistentVolumeClaimRetentionPolicy= new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(persistentVolumeClaimRetentionPolicy); _visitables.get("persistentVolumeClaimRetentionPolicy").add(this.persistentVolumeClaimRetentionPolicy);} else { this.persistentVolumeClaimRetentionPolicy = null; _visitables.get("persistentVolumeClaimRetentionPolicy").remove(this.persistentVolumeClaimRetentionPolicy); } return (A) this;
  }
  public Boolean hasPersistentVolumeClaimRetentionPolicy() {
    return this.persistentVolumeClaimRetentionPolicy != null;
  }
  public A withNewPersistentVolumeClaimRetentionPolicy(String whenDeleted,String whenScaled) {
    return (A)withPersistentVolumeClaimRetentionPolicy(new StatefulSetPersistentVolumeClaimRetentionPolicy(whenDeleted, whenScaled));
  }
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicy() {
    return new StatefulSetSpecFluentImpl.PersistentVolumeClaimRetentionPolicyNestedImpl();
  }
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> withNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return new StatefulSetSpecFluentImpl.PersistentVolumeClaimRetentionPolicyNestedImpl(item);
  }
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editPersistentVolumeClaimRetentionPolicy() {
    return withNewPersistentVolumeClaimRetentionPolicyLike(getPersistentVolumeClaimRetentionPolicy());
  }
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicy() {
    return withNewPersistentVolumeClaimRetentionPolicyLike(getPersistentVolumeClaimRetentionPolicy() != null ? getPersistentVolumeClaimRetentionPolicy(): new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder().build());
  }
  public StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<A> editOrNewPersistentVolumeClaimRetentionPolicyLike(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
    return withNewPersistentVolumeClaimRetentionPolicyLike(getPersistentVolumeClaimRetentionPolicy() != null ? getPersistentVolumeClaimRetentionPolicy(): item);
  }
  public String getPodManagementPolicy() {
    return this.podManagementPolicy;
  }
  public A withPodManagementPolicy(String podManagementPolicy) {
    this.podManagementPolicy=podManagementPolicy; return (A) this;
  }
  public Boolean hasPodManagementPolicy() {
    return this.podManagementPolicy != null;
  }
  public Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public Boolean hasReplicas() {
    return this.replicas != null;
  }
  public Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public Boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
    return new StatefulSetSpecFluentImpl.SelectorNestedImpl();
  }
  public StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new StatefulSetSpecFluentImpl.SelectorNestedImpl(item);
  }
  public StatefulSetSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public String getServiceName() {
    return this.serviceName;
  }
  public A withServiceName(String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  public Boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} else { this.template = null; _visitables.get("template").remove(this.template); } return (A) this;
  }
  public Boolean hasTemplate() {
    return this.template != null;
  }
  public StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
    return new StatefulSetSpecFluentImpl.TemplateNestedImpl();
  }
  public StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new StatefulSetSpecFluentImpl.TemplateNestedImpl(item);
  }
  public StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new PodTemplateSpecBuilder().build());
  }
  public StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @Deprecated
  public StatefulSetUpdateStrategy getUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public StatefulSetUpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy!=null ?this.updateStrategy.build():null;
  }
  public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy) {
    _visitables.get("updateStrategy").remove(this.updateStrategy);
    if (updateStrategy!=null){ this.updateStrategy= new StatefulSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} else { this.updateStrategy = null; _visitables.get("updateStrategy").remove(this.updateStrategy); } return (A) this;
  }
  public Boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new StatefulSetSpecFluentImpl.UpdateStrategyNestedImpl();
  }
  public StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
    return new StatefulSetSpecFluentImpl.UpdateStrategyNestedImpl(item);
  }
  public StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy());
  }
  public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new StatefulSetUpdateStrategyBuilder().build());
  }
  public StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item) {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
  }
  public A addToVolumeClaimTemplates(Integer index,PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(index >= 0 ? index : _visitables.get("volumeClaimTemplates").size(), builder);this.volumeClaimTemplates.add(index >= 0 ? index : volumeClaimTemplates.size(), builder); return (A)this;
  }
  public A setToVolumeClaimTemplates(Integer index,PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("volumeClaimTemplates").size()) { _visitables.get("volumeClaimTemplates").add(builder); } else { _visitables.get("volumeClaimTemplates").set(index, builder);}
    if (index < 0 || index >= volumeClaimTemplates.size()) { volumeClaimTemplates.add(builder); } else { volumeClaimTemplates.set(index, builder);}
     return (A)this;
  }
  public A addToVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new ArrayList<PersistentVolumeClaimBuilder>();}
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  public A removeFromVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items) {
    for (PersistentVolumeClaim item : items) {PersistentVolumeClaimBuilder builder = new PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate) {
    if (volumeClaimTemplates == null) return (A) this;
    final Iterator<PersistentVolumeClaimBuilder> each = volumeClaimTemplates.iterator();
    final List visitables = _visitables.get("volumeClaimTemplates");
    while (each.hasNext()) {
      PersistentVolumeClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<PersistentVolumeClaim> getVolumeClaimTemplates() {
    return volumeClaimTemplates != null ? build(volumeClaimTemplates) : null;
  }
  public List<PersistentVolumeClaim> buildVolumeClaimTemplates() {
    return volumeClaimTemplates != null ? build(volumeClaimTemplates) : null;
  }
  public PersistentVolumeClaim buildVolumeClaimTemplate(Integer index) {
    return this.volumeClaimTemplates.get(index).build();
  }
  public PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(0).build();
  }
  public PersistentVolumeClaim buildLastVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(volumeClaimTemplates.size() - 1).build();
  }
  public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
    for (PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
    for (PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) { _visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);}
    if (volumeClaimTemplates != null) {this.volumeClaimTemplates = new ArrayList(); for (PersistentVolumeClaim item : volumeClaimTemplates){this.addToVolumeClaimTemplates(item);}} else { this.volumeClaimTemplates = null;} return (A) this;
  }
  public A withVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.clear();}
    if (volumeClaimTemplates != null) {for (PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
  }
  public Boolean hasVolumeClaimTemplates() {
    return volumeClaimTemplates != null && !volumeClaimTemplates.isEmpty();
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
    return new StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl();
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item) {
    return new StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl(-1, item);
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(Integer index,PersistentVolumeClaim item) {
    return new StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl(index, item);
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(Integer index) {
    if (volumeClaimTemplates.size() <= index) throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
    if (volumeClaimTemplates.size() == 0) throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(0, buildVolumeClaimTemplate(0));
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
    int index = volumeClaimTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeClaimTemplates.size();i++) { 
    if (predicate.test(volumeClaimTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatefulSetSpecFluentImpl that = (StatefulSetSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (persistentVolumeClaimRetentionPolicy != null ? !persistentVolumeClaimRetentionPolicy.equals(that.persistentVolumeClaimRetentionPolicy) :that.persistentVolumeClaimRetentionPolicy != null) return false;
    if (podManagementPolicy != null ? !podManagementPolicy.equals(that.podManagementPolicy) :that.podManagementPolicy != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
    if (volumeClaimTemplates != null ? !volumeClaimTemplates.equals(that.volumeClaimTemplates) :that.volumeClaimTemplates != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  persistentVolumeClaimRetentionPolicy,  podManagementPolicy,  replicas,  revisionHistoryLimit,  selector,  serviceName,  template,  updateStrategy,  volumeClaimTemplates,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (minReadySeconds != null) { sb.append("minReadySeconds:"); sb.append(minReadySeconds + ","); }
    if (persistentVolumeClaimRetentionPolicy != null) { sb.append("persistentVolumeClaimRetentionPolicy:"); sb.append(persistentVolumeClaimRetentionPolicy + ","); }
    if (podManagementPolicy != null) { sb.append("podManagementPolicy:"); sb.append(podManagementPolicy + ","); }
    if (replicas != null) { sb.append("replicas:"); sb.append(replicas + ","); }
    if (revisionHistoryLimit != null) { sb.append("revisionHistoryLimit:"); sb.append(revisionHistoryLimit + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (serviceName != null) { sb.append("serviceName:"); sb.append(serviceName + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (updateStrategy != null) { sb.append("updateStrategy:"); sb.append(updateStrategy + ","); }
    if (volumeClaimTemplates != null && !volumeClaimTemplates.isEmpty()) { sb.append("volumeClaimTemplates:"); sb.append(volumeClaimTemplates + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class PersistentVolumeClaimRetentionPolicyNestedImpl<N> extends StatefulSetPersistentVolumeClaimRetentionPolicyFluentImpl<StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>> implements StatefulSetSpecFluent.PersistentVolumeClaimRetentionPolicyNested<N>,Nested<N>{
    PersistentVolumeClaimRetentionPolicyNestedImpl(StatefulSetPersistentVolumeClaimRetentionPolicy item) {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this, item);
    }
    PersistentVolumeClaimRetentionPolicyNestedImpl() {
      this.builder = new StatefulSetPersistentVolumeClaimRetentionPolicyBuilder(this);
    }
    StatefulSetPersistentVolumeClaimRetentionPolicyBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withPersistentVolumeClaimRetentionPolicy(builder.build());
    }
    public N endPersistentVolumeClaimRetentionPolicy() {
      return and();
    }
    
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<StatefulSetSpecFluent.SelectorNested<N>> implements StatefulSetSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<StatefulSetSpecFluent.TemplateNested<N>> implements StatefulSetSpecFluent.TemplateNested<N>,Nested<N>{
    TemplateNestedImpl(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new PodTemplateSpecBuilder(this);
    }
    PodTemplateSpecBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  class UpdateStrategyNestedImpl<N> extends StatefulSetUpdateStrategyFluentImpl<StatefulSetSpecFluent.UpdateStrategyNested<N>> implements StatefulSetSpecFluent.UpdateStrategyNested<N>,Nested<N>{
    UpdateStrategyNestedImpl(StatefulSetUpdateStrategy item) {
      this.builder = new StatefulSetUpdateStrategyBuilder(this, item);
    }
    UpdateStrategyNestedImpl() {
      this.builder = new StatefulSetUpdateStrategyBuilder(this);
    }
    StatefulSetUpdateStrategyBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy() {
      return and();
    }
    
  }
  class VolumeClaimTemplatesNestedImpl<N> extends PersistentVolumeClaimFluentImpl<StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> implements StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,Nested<N>{
    VolumeClaimTemplatesNestedImpl(Integer index,PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new PersistentVolumeClaimBuilder(this, item);
    }
    VolumeClaimTemplatesNestedImpl() {
      this.index = -1;
      this.builder = new PersistentVolumeClaimBuilder(this);
    }
    PersistentVolumeClaimBuilder builder;
    Integer index;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(index,builder.build());
    }
    public N endVolumeClaimTemplate() {
      return and();
    }
    
  }
  
}