package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ReplicaSetStatusBuilder extends io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluentImpl<io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus,io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusBuilder> {

    io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ReplicaSetStatusBuilder() {
        this(true);
    }

    public ReplicaSetStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ReplicaSetStatus(), validationEnabled);
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus instance) {
        this(fluent, instance, true);
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAvailableReplicas(instance.getAvailableReplicas()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        fluent.withObservedGeneration(instance.getObservedGeneration()); 
        fluent.withReadyReplicas(instance.getReadyReplicas()); 
        fluent.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus instance) {
        this(instance,true);
    }

    public ReplicaSetStatusBuilder(io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAvailableReplicas(instance.getAvailableReplicas()); 
        this.withConditions(instance.getConditions()); 
        this.withFullyLabeledReplicas(instance.getFullyLabeledReplicas()); 
        this.withObservedGeneration(instance.getObservedGeneration()); 
        this.withReadyReplicas(instance.getReadyReplicas()); 
        this.withReplicas(instance.getReplicas()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.apps.ReplicaSetStatus build() {
        ReplicaSetStatus buildable = new ReplicaSetStatus(fluent.getAvailableReplicas(),fluent.getConditions(),fluent.getFullyLabeledReplicas(),fluent.getObservedGeneration(),fluent.getReadyReplicas(),fluent.getReplicas());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ReplicaSetStatusBuilder that = (ReplicaSetStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
