package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import java.lang.String;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import java.lang.Integer;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

public interface StatefulSetSpecFluent<A extends StatefulSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public String getPodManagementPolicy();
    public A withPodManagementPolicy(String podManagementPolicy);
    public Boolean hasPodManagementPolicy();
    public A withNewPodManagementPolicy(StringBuilder arg1);
    public A withNewPodManagementPolicy(int[] arg1,int arg2,int arg3);
    public A withNewPodManagementPolicy(char[] arg1);
    public A withNewPodManagementPolicy(StringBuffer arg1);
    public A withNewPodManagementPolicy(byte[] arg1,int arg2);
    public A withNewPodManagementPolicy(byte[] arg1);
    public A withNewPodManagementPolicy(char[] arg1,int arg2,int arg3);
    public A withNewPodManagementPolicy(byte[] arg1,int arg2,int arg3);
    public A withNewPodManagementPolicy(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewPodManagementPolicy(String arg1);
    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public Boolean hasReplicas();
    public A withNewReplicas(int arg0);
    public Integer getRevisionHistoryLimit();
    public A withRevisionHistoryLimit(Integer revisionHistoryLimit);
    public Boolean hasRevisionHistoryLimit();
    public A withNewRevisionHistoryLimit(int arg0);
    
/**
 * This method has been deprecated, please use method buildSelector instead.
 * @return The buildable object.
 */
@Deprecated public LabelSelector getSelector();
    public LabelSelector buildSelector();
    public A withSelector(LabelSelector selector);
    public Boolean hasSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
    public String getServiceName();
    public A withServiceName(String serviceName);
    public Boolean hasServiceName();
    public A withNewServiceName(StringBuilder arg1);
    public A withNewServiceName(int[] arg1,int arg2,int arg3);
    public A withNewServiceName(char[] arg1);
    public A withNewServiceName(StringBuffer arg1);
    public A withNewServiceName(byte[] arg1,int arg2);
    public A withNewServiceName(byte[] arg1);
    public A withNewServiceName(char[] arg1,int arg2,int arg3);
    public A withNewServiceName(byte[] arg1,int arg2,int arg3);
    public A withNewServiceName(byte[] arg1,int arg2,int arg3,int arg4);
    public A withNewServiceName(String arg1);
    
/**
 * This method has been deprecated, please use method buildTemplate instead.
 * @return The buildable object.
 */
@Deprecated public PodTemplateSpec getTemplate();
    public PodTemplateSpec buildTemplate();
    public A withTemplate(PodTemplateSpec template);
    public Boolean hasTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item);
    
/**
 * This method has been deprecated, please use method buildUpdateStrategy instead.
 * @return The buildable object.
 */
@Deprecated public StatefulSetUpdateStrategy getUpdateStrategy();
    public StatefulSetUpdateStrategy buildUpdateStrategy();
    public A withUpdateStrategy(StatefulSetUpdateStrategy updateStrategy);
    public Boolean hasUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(StatefulSetUpdateStrategy item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(StatefulSetUpdateStrategy item);
    public A addToVolumeClaimTemplates(int index,PersistentVolumeClaim item);
    public A setToVolumeClaimTemplates(int index,PersistentVolumeClaim item);
    public A addToVolumeClaimTemplates(PersistentVolumeClaim... items);
    public A addAllToVolumeClaimTemplates(Collection<PersistentVolumeClaim> items);
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim... items);
    public A removeAllFromVolumeClaimTemplates(Collection<PersistentVolumeClaim> items);
    public A removeMatchingFromVolumeClaimTemplates(Predicate<PersistentVolumeClaimBuilder> predicate);
    
/**
 * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
 * @return The buildable object.
 */
@Deprecated public List<PersistentVolumeClaim> getVolumeClaimTemplates();
    public List<PersistentVolumeClaim> buildVolumeClaimTemplates();
    public PersistentVolumeClaim buildVolumeClaimTemplate(int index);
    public PersistentVolumeClaim buildFirstVolumeClaimTemplate();
    public PersistentVolumeClaim buildLastVolumeClaimTemplate();
    public PersistentVolumeClaim buildMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate);
    public Boolean hasMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate);
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates);
    public Boolean hasVolumeClaimTemplates();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(int index,PersistentVolumeClaim item);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(int index);
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate();
    public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(Predicate<PersistentVolumeClaimBuilder> predicate);
    public interface SelectorNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,LabelSelectorFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<N>> {

            public N and();
            public N endSelector();    }


    public interface TemplateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodTemplateSpecFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<N>> {

            public N and();
            public N endTemplate();    }


    public interface UpdateStrategyNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,StatefulSetUpdateStrategyFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<N>> {

            public N and();
            public N endUpdateStrategy();    }


    public interface VolumeClaimTemplatesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimFluent<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> {

            public N and();
            public N endVolumeClaimTemplate();    }


}
