package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ControllerRevisionListBuilder extends ControllerRevisionListFluentImpl<ControllerRevisionListBuilder> implements VisitableBuilder<ControllerRevisionList,ControllerRevisionListBuilder> {

    ControllerRevisionListFluent<?> fluent;
    Boolean validationEnabled;

    public ControllerRevisionListBuilder() { 
        this(true);
    }


    public ControllerRevisionListBuilder(Boolean validationEnabled) { 
        this(new ControllerRevisionList(), validationEnabled);
    }


    public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent) { 
        this(fluent, true);
    }


    public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,Boolean validationEnabled) { 
        this(fluent, new ControllerRevisionList(), validationEnabled);
    }


    public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,ControllerRevisionList instance) { 
        this(fluent, instance, true);
    }


    public ControllerRevisionListBuilder(ControllerRevisionListFluent<?> fluent,ControllerRevisionList instance,Boolean validationEnabled) { 
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ControllerRevisionListBuilder(ControllerRevisionList instance) { 
        this(instance,true);
    }


    public ControllerRevisionListBuilder(ControllerRevisionList instance,Boolean validationEnabled) { 
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }


    public ControllerRevisionList build() {
        ControllerRevisionList buildable = new ControllerRevisionList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ControllerRevisionListBuilder that = (ControllerRevisionListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
