/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.annotator;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationArrayMember;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JType;
import io.fabric8.kubernetes.model.annotation.ApiGroup;
import io.fabric8.kubernetes.model.annotation.ApiVersion;
import io.fabric8.kubernetes.model.annotation.PackageSuffix;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import io.sundr.transform.annotations.VelocityTransformation;
import io.sundr.transform.annotations.VelocityTransformations;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesCoreTypeAnnotator
extends Jackson2Annotator {
    protected final Map<String, JDefinedClass> pendingResources = new HashMap<String, JDefinedClass>();
    protected final Map<String, JDefinedClass> pendingLists = new HashMap<String, JDefinedClass>();
    protected String moduleName = null;

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        JAnnotationArrayMember annotationValue = clazz.annotate(JsonPropertyOrder.class).paramArray("value");
        annotationValue.param("apiVersion");
        annotationValue.param("kind");
        annotationValue.param("metadata");
        Iterator properties = propertiesNode.fieldNames();
        while (properties.hasNext()) {
            String next = (String)properties.next();
            if (next.equals("apiVersion") || next.equals("kind") || next.equals("metadata")) continue;
            annotationValue.param(next);
        }
        clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        this.processBuildable(clazz);
        if (clazz.fields().containsKey("kind") && clazz.fields().containsKey("metadata")) {
            String resourceName;
            if (clazz.name().endsWith("List")) {
                resourceName = clazz.name().substring(0, clazz.name().length() - 4);
                this.pendingLists.put(resourceName, clazz);
            } else {
                resourceName = clazz.name();
                this.pendingResources.put(clazz.name(), clazz);
            }
            if (this.pendingResources.containsKey(resourceName) && this.pendingLists.containsKey(resourceName)) {
                JDefinedClass resourceClass = this.pendingResources.get(resourceName);
                JDefinedClass resourceListClass = this.pendingLists.get(resourceName);
                String apiVersion = propertiesNode.get("apiVersion").get("default").toString().replaceAll(Pattern.quote("\""), "");
                String apiGroup = "";
                if (apiVersion.contains("/")) {
                    apiGroup = apiVersion.substring(0, apiVersion.lastIndexOf("/"));
                    apiVersion = apiVersion.substring(apiGroup.length() + 1);
                }
                String packageSuffix = this.getPackageSuffix(apiVersion);
                resourceClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceClass.annotate(ApiGroup.class).param("value", apiGroup);
                resourceClass.annotate(PackageSuffix.class).param("value", packageSuffix);
                resourceListClass.annotate(ApiVersion.class).param("value", apiVersion);
                resourceListClass.annotate(ApiGroup.class).param("value", apiGroup);
                resourceListClass.annotate(PackageSuffix.class).param("value", packageSuffix);
                this.pendingLists.remove(resourceName);
                this.pendingResources.remove(resourceName);
            }
            this.addClassesToPropertyFiles(clazz);
        }
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
        if (this.moduleName == null) {
            this.moduleName = schema.get("$module").textValue();
        }
        super.propertyInclusion(clazz, schema);
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
        super.propertyField(field, clazz, propertyName, propertyNode);
        if (propertyNode.has("javaOmitEmpty") && propertyNode.get("javaOmitEmpty").asBoolean(false)) {
            field.annotate(JsonInclude.class).param("value", (Enum)JsonInclude.Include.NON_EMPTY);
        }
    }

    protected void processBuildable(JDefinedClass clazz) {
        try {
            clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", false).param("generateBuilderPackage", true).param("lazyCollectionInitEnabled", false).param("builderPackage", "io.fabric8.kubernetes.api.builder").annotationParam("inline", Inline.class).param("type", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Doneable")).param("prefix", "Doneable").param("value", "done");
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    protected void addClassesToPropertyFiles(JDefinedClass clazz) {
        String packageCategory = this.getPackageCategory(clazz.getPackage().name());
        if (this.moduleName.equals(packageCategory) && this.shouldIncludeClass(clazz.name())) {
            JAnnotationArrayMember arrayMember = clazz.annotate(VelocityTransformations.class).paramArray("value");
            arrayMember.annotate(VelocityTransformation.class).param("value", "/manifest.vm").param("outputPath", this.moduleName + ".properties").param("gather", true);
        }
    }

    private String getPackageCategory(String packageName) {
        if (packageName.isEmpty()) {
            return null;
        }
        if (packageName.equals("io.fabric8.kubernetes.api.model")) {
            return "core";
        }
        if (packageName.equals("io.fabric8.openshift.api.model")) {
            return "openshift";
        }
        String[] parts = packageName.split("\\.");
        if (parts.length < 6) {
            throw new IllegalArgumentException("Invalid package name encountered: " + packageName);
        }
        return parts[5];
    }

    public boolean shouldIncludeClass(String className) {
        return !className.contains("ServiceReference") && !className.equals("AllowedFlexVolume") && !className.equals("DeploymentCondition") && !className.equals("FSGroupStrategyOptions") && !className.equals("PolicyRule") && !className.equals("IDRange") && !className.equals("SupplementalGroupsStrategyOptions") && !className.equals("PodIP") && !className.equals("VolumeAttachmentSource") && !className.equals("DeploymentStrategy") && !className.contains("List") && !className.equals("BuildRequest") && !className.equals("ImageSignature") && !className.equals("ImageStreamImport") && !className.equals("RoleBindingRestriction") && !className.equals("Scale") && !className.equals("Status") && !className.equals("TokenReview") && !className.equals("RouteIngress") && !className.equals("ProjectRequest") && !className.equals("WebhookClientConfig");
    }

    private String getPackageSuffix(String apiVersion) {
        StringBuilder packageSuffixBuilder = new StringBuilder();
        packageSuffixBuilder.append(".");
        packageSuffixBuilder.append(this.moduleName);
        packageSuffixBuilder.append(".");
        packageSuffixBuilder.append(apiVersion);
        return packageSuffixBuilder.toString();
    }
}

