/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.annotator;

import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.sun.codemodel.JAnnotationUse;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JEnumConstant;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JType;
import io.sundr.builder.annotations.Buildable;
import io.sundr.builder.annotations.Inline;
import java.util.Map;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.jsonschema2pojo.Jackson2Annotator;

public class KubernetesTypeAnnotator
extends Jackson2Annotator {
    private final String nameIsDNS952LabelPattern = "[a-z]([-a-z0-9]*[a-z0-9])?";
    private final int nameIsDNS952LabelLength = 24;
    private final String nameIsDNS1123LabelPattern = "[a-z0-9]([-a-z0-9]*[a-z0-9])?";
    private final int nameIsDNS1123LabelLength = 63;
    private final String nameIsDNS1123SubdomainPattern = "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    private final int nameIsDNS1123SubdomainLength = 253;

    public void propertyOrder(JDefinedClass clazz, JsonNode propertiesNode) {
        clazz.annotate(JsonDeserialize.class).param("using", JsonDeserializer.None.class);
        clazz.annotate(ToString.class);
        clazz.annotate(EqualsAndHashCode.class);
        try {
            clazz.annotate(Buildable.class).param("editableEnabled", false).param("validationEnabled", true).param("generateBuilderPackage", true).param("builderPackage", "io.fabric8.kubernetes.api.builder").annotationParam("inline", Inline.class).param("type", (JType)new JCodeModel()._class("io.fabric8.kubernetes.api.model.Doneable")).param("prefix", "Doneable").param("value", "done");
            this.annotateMetatadataValidator(clazz);
        }
        catch (JClassAlreadyExistsException e) {
            e.printStackTrace();
        }
    }

    private int getObjectNameMaxLength(JDefinedClass clazz) {
        String kind = clazz.name();
        if (kind.equals("Service")) {
            return 24;
        }
        if (kind.equals("Namespace") || kind.equals("Project")) {
            return 63;
        }
        return 253;
    }

    private String getObjectNamePattern(JDefinedClass clazz) {
        String kind = clazz.name();
        if (kind.equals("Service")) {
            return "[a-z]([-a-z0-9]*[a-z0-9])?";
        }
        if (kind.equals("Namespace") || kind.equals("Project")) {
            return "[a-z0-9]([-a-z0-9]*[a-z0-9])?";
        }
        return "[a-z0-9]([-a-z0-9]*[a-z0-9])?(\\.[a-z0-9]([-a-z0-9]*[a-z0-9])?)*";
    }

    private void annotateMetatadataValidator(JDefinedClass clazz) {
        if (clazz.name().equals("PodTemplateSpec")) {
            return;
        }
        for (Map.Entry f : clazz.fields().entrySet()) {
            if (!((String)f.getKey()).equals("metadata") || !((JFieldVar)f.getValue()).type().name().equals("ObjectMeta")) continue;
            try {
                JAnnotationUse annotation = ((JFieldVar)f.getValue()).annotate((JClass)new JCodeModel()._class("io.fabric8.kubernetes.api.model.validators.CheckObjectMeta"));
                if (this.isMinimal(clazz)) {
                    annotation.param("minimal", true);
                } else {
                    annotation.param("regexp", "^" + this.getObjectNamePattern(clazz) + "$").param("max", this.getObjectNameMaxLength(clazz));
                }
            }
            catch (JClassAlreadyExistsException e) {
                e.printStackTrace();
            }
            return;
        }
    }

    private boolean isMinimal(JDefinedClass clazz) {
        String kind = clazz.name();
        return kind.equals("Group") || kind.equals("User") || kind.equals("Identity") || kind.equals("UserIdentityMapping") || kind.equals("ClusterNetwork") || kind.equals("HostSubnet") || kind.equals("NetNamespace") || kind.equals("Image") || kind.equals("ImageStream") || kind.equals("ImageStreamMapping") || kind.equals("ImageStreamTag") || kind.equals("ImageStreamImport") || kind.equals("Policy") || kind.equals("PolicyBinding") || kind.equals("Role") || kind.equals("RoleBinding") || kind.equals("OAuthAccessToken") || kind.equals("OAuthAuthorizeToken") || kind.equals("OAuthClientAuthorization");
    }

    public void propertyInclusion(JDefinedClass clazz, JsonNode schema) {
    }

    public void propertyField(JFieldVar field, JDefinedClass clazz, String propertyName, JsonNode propertyNode) {
    }

    public void propertyGetter(JMethod getter, String propertyName) {
    }

    public void propertySetter(JMethod setter, String propertyName) {
    }

    public void anyGetter(JMethod getter) {
    }

    public void anySetter(JMethod setter) {
    }

    public void enumCreatorMethod(JMethod creatorMethod) {
    }

    public void enumValueMethod(JMethod valueMethod) {
    }

    public void enumConstant(JEnumConstant constant, String value) {
    }

    public boolean isAdditionalPropertiesSupported() {
        return true;
    }

    public void additionalPropertiesField(JFieldVar field, JDefinedClass clazz, String propertyName) {
    }
}

