/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock.impl;

import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientPodResource;
import io.fabric8.kubernetes.client.dsl.ContainerResource;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import io.fabric8.kubernetes.client.mock.BaseMockOperation;
import io.fabric8.kubernetes.client.mock.MockPodResource;
import io.fabric8.kubernetes.client.mock.Mockable;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneablePod;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;

public class MockPod<C extends Client>
extends BaseMockOperation<Pod, PodList, DoneablePod, MockDoneablePod, ClientPodResource<Pod, DoneablePod>, MockPodResource<Pod, MockDoneablePod, Boolean>>
implements MockPodResource<Pod, MockDoneablePod, Boolean> {
    private final Set<Mockable> nested = new LinkedHashSet<Mockable>();
    private Map<IArgumentMatcher, MockPod> containerMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> inMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> outMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> errMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> inPipeMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> outPipeMap = new HashMap<IArgumentMatcher, MockPod>();
    private Map<IArgumentMatcher, MockPod> errPipeMap = new HashMap<IArgumentMatcher, MockPod>();
    private final Map<IArgumentMatcher, MockPod> sinceTimeMap = new HashMap<IArgumentMatcher, MockPod>();
    private final Map<IArgumentMatcher, MockPod> sinceSecondsMap = new HashMap<IArgumentMatcher, MockPod>();
    private final Map<IArgumentMatcher, MockPod> tailMap = new HashMap<IArgumentMatcher, MockPod>();
    private final Map<IArgumentMatcher, MockPod> logOutputMap = new HashMap<IArgumentMatcher, MockPod>();
    private MockPod redirectIn;
    private MockPod redirectOut;
    private MockPod redirectErr;
    private MockPod allocatingTerminalMock;
    private MockPod terminatedStatusMock;
    private MockPod prettyOutputMock;

    public MockPod() {
        super((ClientMixedOperation)EasyMock.createMock(PodDelegate.class));
    }

    @Override
    public BaseMockOperation newInstance() {
        return new MockPod<C>();
    }

    public IExpectationSetters<String> getLog() {
        return EasyMock.expect((Object)this.getDelegate().getLog());
    }

    public IExpectationSetters<String> getLog(String id) {
        return EasyMock.expect((Object)this.getDelegate().getLog(id));
    }

    public IExpectationSetters<String> getLog(Boolean isPretty) {
        return EasyMock.expect((Object)this.getDelegate().getLog(isPretty));
    }

    public IExpectationSetters<LogWatch> watchLog() {
        return EasyMock.expect((Object)this.getDelegate().watchLog());
    }

    public IExpectationSetters<LogWatch> watchLog(OutputStream out) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)out);
        MockPod<C> op = this.logOutputMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            this.nested.add(op);
            this.logOutputMap.put(matcher, op);
        }
        return EasyMock.expect((Object)this.getDelegate().watchLog(out));
    }

    public IExpectationSetters<String> getLog(String id, Boolean isPretty) {
        return EasyMock.expect((Object)this.getDelegate().getLog(id, isPretty));
    }

    public IExpectationSetters<ExecWatch> exec(String ... input) {
        return EasyMock.expect((Object)this.getDelegate().exec(input));
    }

    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> readingInput(InputStream in) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)in);
        MockPod<C> op = this.inMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().readingInput(in)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.containerMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> writingInput(PipedOutputStream out) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)out);
        MockPod<C> op = this.inPipeMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().writingInput(out)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.inPipeMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecOutputErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> redirectingInput() {
        if (this.redirectIn == null) {
            this.redirectIn = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().redirectingInput()).andReturn((Object)this.redirectIn.getDelegate()).anyTimes();
        return this.redirectIn;
    }

    public TtyExecErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> writingOutput(OutputStream out) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)out);
        MockPod<C> op = this.outMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().writingOutput(out)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.containerMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> readingOutput(PipedInputStream in) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)in);
        MockPod<C> op = this.outPipeMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().readingOutput(in)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.outPipeMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecErrorable<String, OutputStream, PipedInputStream, IExpectationSetters<ExecWatch>> redirectingOutput() {
        if (this.redirectOut == null) {
            this.redirectOut = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().redirectingInput()).andReturn((Object)this.redirectOut.getDelegate()).anyTimes();
        return this.redirectOut;
    }

    public TtyExecable<String, IExpectationSetters<ExecWatch>> writingError(OutputStream err) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)err);
        MockPod<C> op = this.errMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().writingError(err)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.containerMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecable<String, IExpectationSetters<ExecWatch>> readingError(PipedInputStream in) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)in);
        MockPod<C> op = this.errPipeMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().readingOutput(in)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.errPipeMap.put(matcher, op);
        }
        return op;
    }

    public TtyExecable<String, IExpectationSetters<ExecWatch>> redirectingError() {
        if (this.redirectErr == null) {
            this.redirectErr = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().redirectingInput()).andReturn((Object)this.redirectErr.getDelegate()).anyTimes();
        return this.redirectErr;
    }

    public ExecListenable<String, IExpectationSetters<ExecWatch>> withTTY() {
        if (this.allocatingTerminalMock == null) {
            this.allocatingTerminalMock = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().withTTY()).andReturn((Object)this.allocatingTerminalMock.getDelegate()).anyTimes();
        this.nested.add(this.allocatingTerminalMock);
        return this.allocatingTerminalMock;
    }

    public ContainerResource<String, LogWatch, InputStream, PipedOutputStream, OutputStream, PipedInputStream, String, IExpectationSetters<ExecWatch>> inContainer(String containerId) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)containerId);
        MockPod<C> op = this.containerMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().inContainer(containerId)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.containerMap.put(matcher, op);
        }
        return op;
    }

    public Loggable<IExpectationSetters<String>, IExpectationSetters<LogWatch>> withPrettyOutput() {
        if (this.prettyOutputMock == null) {
            this.prettyOutputMock = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().withPrettyOutput()).andReturn((Object)this.prettyOutputMock.getDelegate()).anyTimes();
        this.nested.add(this.allocatingTerminalMock);
        return this.prettyOutputMock;
    }

    public PrettyLoggable<IExpectationSetters<String>, IExpectationSetters<LogWatch>> tailingLines(int lines) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)lines);
        MockPod<C> op = this.tailMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().tailingLines(lines)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.tailMap.put(matcher, op);
        }
        return op;
    }

    public TimeTailPrettyLoggable<IExpectationSetters<String>, IExpectationSetters<LogWatch>> terminated() {
        if (this.terminatedStatusMock == null) {
            this.terminatedStatusMock = new MockPod<C>();
        }
        EasyMock.expect((Object)this.getDelegate().withPrettyOutput()).andReturn((Object)this.terminatedStatusMock.getDelegate()).anyTimes();
        this.nested.add(this.terminatedStatusMock);
        return this.terminatedStatusMock;
    }

    public TailPrettyLoggable<IExpectationSetters<String>, IExpectationSetters<LogWatch>> sinceTime(String timestamp) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)timestamp);
        MockPod<C> op = this.sinceTimeMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().sinceTime(timestamp)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.sinceTimeMap.put(matcher, op);
        }
        return op;
    }

    public TailPrettyLoggable<IExpectationSetters<String>, IExpectationSetters<LogWatch>> sinceSeconds(int seconds) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)seconds);
        MockPod<C> op = this.sinceSecondsMap.get(matcher);
        if (op == null) {
            op = new MockPod<C>();
            EasyMock.expect((Object)this.getDelegate().sinceSeconds(seconds)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.sinceSecondsMap.put(matcher, op);
        }
        return op;
    }

    public Execable<String, IExpectationSetters<ExecWatch>> usingListener(ExecListener listener) {
        EasyMock.expect((Object)this.getDelegate().usingListener(listener)).andReturn((Object)this.getDelegate()).once();
        return this;
    }

    public PodDelegate getDelegate() {
        return (PodDelegate)super.getDelegate();
    }

    @Override
    public void verify() {
        for (Mockable mockable : this.nested) {
            mockable.verify();
        }
        super.verify();
    }

    @Override
    public Void replay() {
        for (Mockable mockable : this.nested) {
            mockable.replay();
        }
        return super.replay();
    }

    private static interface PodDelegate
    extends ClientMixedOperation<Pod, PodList, DoneablePod, ClientPodResource<Pod, DoneablePod>>,
    ClientPodResource<Pod, DoneablePod> {
    }
}

