/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.extensions.HorizontalPodAutoscalerList;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSet;
import io.fabric8.kubernetes.api.model.extensions.ReplicaSetList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.MockRollableScaleableResource;
import io.fabric8.kubernetes.client.mock.MockScaleableResource;
import io.fabric8.kubernetes.client.mock.Replayable;
import io.fabric8.kubernetes.client.mock.Verifiable;
import io.fabric8.kubernetes.client.mock.impl.MockDaemonSet;
import io.fabric8.kubernetes.client.mock.impl.MockDeployment;
import io.fabric8.kubernetes.client.mock.impl.MockHorizontalPodAutoscaler;
import io.fabric8.kubernetes.client.mock.impl.MockIngress;
import io.fabric8.kubernetes.client.mock.impl.MockJob;
import io.fabric8.kubernetes.client.mock.impl.MockReplicaSet;
import io.fabric8.kubernetes.client.mock.impl.MockThirdPartyResource;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableDaemonSet;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableDeployment;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableHorizontalPodAutoscaler;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableIngress;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableJob;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableReplicaSet;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableThirdPartyResource;
import org.easymock.EasyMock;

public class ExtensionsAPIGroupMockClient
implements Replayable<ExtensionsAPIGroupDSL>,
Verifiable {
    private final ExtensionsAPIGroupDSL client = (ExtensionsAPIGroupDSL)EasyMock.createMock(ExtensionsAPIGroupDSL.class);
    private MockJob jobs = new MockJob();
    private MockDeployment deployments = new MockDeployment();
    private MockIngress ingresses = new MockIngress();
    private MockDaemonSet daemonSets = new MockDaemonSet();
    private MockThirdPartyResource thirdPartyResources = new MockThirdPartyResource();
    private MockReplicaSet replicaSets = new MockReplicaSet();
    private MockHorizontalPodAutoscaler horizontalPodAutoscalers = new MockHorizontalPodAutoscaler();

    public ExtensionsAPIGroupMockClient() {
        EasyMock.expect((Object)this.client.jobs()).andReturn(this.jobs.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.deployments()).andReturn(this.deployments.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.ingress()).andReturn(this.ingresses.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.ingresses()).andReturn(this.ingresses.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.daemonSets()).andReturn(this.daemonSets.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.thirdPartyResources()).andReturn(this.thirdPartyResources.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.replicaSets()).andReturn(this.replicaSets.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.horizontalPodAutoscalers()).andReturn(this.horizontalPodAutoscalers.getDelegate()).anyTimes();
        this.client.close();
        EasyMock.expectLastCall().anyTimes();
    }

    @Override
    public ExtensionsAPIGroupDSL replay() {
        this.jobs.replay();
        this.deployments.replay();
        this.ingresses.replay();
        this.daemonSets.replay();
        this.thirdPartyResources.replay();
        this.replicaSets.replay();
        this.horizontalPodAutoscalers.replay();
        EasyMock.replay((Object[])new Object[]{this.client});
        return this.client;
    }

    @Override
    public void verify() {
        this.jobs.verify();
        this.deployments.verify();
        this.ingresses.verify();
        this.daemonSets.verify();
        this.thirdPartyResources.verify();
        this.replicaSets.verify();
        this.horizontalPodAutoscalers.verify();
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    public MockOperation<Job, JobList, MockDoneableJob, MockScaleableResource<Job, MockDoneableJob, Boolean>> jobs() {
        return this.jobs;
    }

    public MockOperation<Deployment, DeploymentList, MockDoneableDeployment, MockScaleableResource<Deployment, MockDoneableDeployment, Boolean>> deployments() {
        return this.deployments;
    }

    @Deprecated
    public MockOperation<Ingress, IngressList, MockDoneableIngress, MockResource<Ingress, MockDoneableIngress, Boolean>> ingress() {
        return this.ingresses;
    }

    public MockOperation<Ingress, IngressList, MockDoneableIngress, MockResource<Ingress, MockDoneableIngress, Boolean>> ingresses() {
        return this.ingresses;
    }

    public MockOperation<DaemonSet, DaemonSetList, MockDoneableDaemonSet, MockResource<DaemonSet, MockDoneableDaemonSet, Boolean>> daemonSets() {
        return this.daemonSets;
    }

    public MockOperation<ThirdPartyResource, ThirdPartyResourceList, MockDoneableThirdPartyResource, MockResource<ThirdPartyResource, MockDoneableThirdPartyResource, Boolean>> thirdPartyResources() {
        return this.thirdPartyResources;
    }

    public MockOperation<ReplicaSet, ReplicaSetList, MockDoneableReplicaSet, MockRollableScaleableResource<ReplicaSet, MockDoneableReplicaSet, Boolean>> replicaSets() {
        return this.replicaSets;
    }

    public MockOperation<HorizontalPodAutoscaler, HorizontalPodAutoscalerList, MockDoneableHorizontalPodAutoscaler, MockResource<HorizontalPodAutoscaler, MockDoneableHorizontalPodAutoscaler, Boolean>> horizontalPodAutoscalers() {
        return this.horizontalPodAutoscalers;
    }

    public ExtensionsAPIGroupDSL getDelegate() {
        return this.client;
    }
}

