/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.ConfigMap;
import io.fabric8.kubernetes.api.model.extensions.ConfigMapList;
import io.fabric8.kubernetes.api.model.extensions.DaemonSet;
import io.fabric8.kubernetes.api.model.extensions.DaemonSetList;
import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.Ingress;
import io.fabric8.kubernetes.api.model.extensions.IngressList;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResource;
import io.fabric8.kubernetes.api.model.extensions.ThirdPartyResourceList;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.Replayable;
import io.fabric8.kubernetes.client.mock.Verifiable;
import io.fabric8.kubernetes.client.mock.impl.MockConfigMap;
import io.fabric8.kubernetes.client.mock.impl.MockDaemonSet;
import io.fabric8.kubernetes.client.mock.impl.MockDeployment;
import io.fabric8.kubernetes.client.mock.impl.MockIngress;
import io.fabric8.kubernetes.client.mock.impl.MockJobs;
import io.fabric8.kubernetes.client.mock.impl.MockThirdPartyResource;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableConfigMap;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableDaemonSet;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableDeployment;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableIngress;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableJob;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableThirdPartyResource;
import org.easymock.EasyMock;

public class ExtensionsAPIGroupMockClient
implements Replayable<ExtensionsAPIGroupDSL>,
Verifiable {
    private final ExtensionsAPIGroupDSL client = (ExtensionsAPIGroupDSL)EasyMock.createMock(ExtensionsAPIGroupDSL.class);
    private MockJobs jobs = new MockJobs();
    private MockDeployment deployments = new MockDeployment();
    private MockIngress ingresses = new MockIngress();
    private MockDaemonSet daemonSets = new MockDaemonSet();
    private MockConfigMap configMaps = new MockConfigMap();
    private MockThirdPartyResource thirdPartyResources = new MockThirdPartyResource();

    public ExtensionsAPIGroupMockClient() {
        EasyMock.expect((Object)this.client.jobs()).andReturn(this.jobs.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.deployments()).andReturn(this.deployments.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.ingress()).andReturn(this.ingresses.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.ingresses()).andReturn(this.ingresses.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.daemonSets()).andReturn(this.daemonSets.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.configMaps()).andReturn(this.configMaps.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.thirdPartyResources()).andReturn(this.thirdPartyResources.getDelegate()).anyTimes();
        this.client.close();
        EasyMock.expectLastCall().anyTimes();
    }

    @Override
    public ExtensionsAPIGroupDSL replay() {
        this.jobs.replay();
        this.deployments.replay();
        EasyMock.replay((Object[])new Object[]{this.client});
        return this.client;
    }

    @Override
    public void verify() {
        this.jobs.verify();
        this.deployments.verify();
        this.ingresses.verify();
        this.daemonSets.verify();
        this.configMaps.verify();
        this.thirdPartyResources.verify();
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    public MockOperation<Job, JobList, MockDoneableJob, MockResource<Job, MockDoneableJob, Boolean>> jobs() {
        return this.jobs;
    }

    public MockOperation<Deployment, DeploymentList, MockDoneableDeployment, MockResource<Deployment, MockDoneableDeployment, Boolean>> deployments() {
        return this.deployments;
    }

    @Deprecated
    public MockOperation<Ingress, IngressList, MockDoneableIngress, MockResource<Ingress, MockDoneableIngress, Boolean>> ingress() {
        return this.ingresses;
    }

    public MockOperation<Ingress, IngressList, MockDoneableIngress, MockResource<Ingress, MockDoneableIngress, Boolean>> ingresses() {
        return this.ingresses;
    }

    public MockOperation<DaemonSet, DaemonSetList, MockDoneableDaemonSet, MockResource<DaemonSet, MockDoneableDaemonSet, Boolean>> daemonSets() {
        return this.daemonSets;
    }

    public MockOperation<ConfigMap, ConfigMapList, MockDoneableConfigMap, MockResource<ConfigMap, MockDoneableConfigMap, Boolean>> configMaps() {
        return this.configMaps;
    }

    public MockOperation<ThirdPartyResource, ThirdPartyResourceList, MockDoneableThirdPartyResource, MockResource<ThirdPartyResource, MockDoneableThirdPartyResource, Boolean>> thirdPartyResources() {
        return this.thirdPartyResources;
    }

    public ExtensionsAPIGroupDSL getDelegate() {
        return this.client;
    }
}

