/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.extensions.Deployment;
import io.fabric8.kubernetes.api.model.extensions.DeploymentList;
import io.fabric8.kubernetes.api.model.extensions.Job;
import io.fabric8.kubernetes.api.model.extensions.JobList;
import io.fabric8.kubernetes.client.dsl.ExtensionsAPIGroupDSL;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.Replayable;
import io.fabric8.kubernetes.client.mock.Verifiable;
import io.fabric8.kubernetes.client.mock.impl.MockDeployment;
import io.fabric8.kubernetes.client.mock.impl.MockJobs;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableDeployment;
import io.fabric8.kubernetes.client.mock.impl.donable.MockDoneableJob;
import org.easymock.EasyMock;

public class ExtensionsAPIGroupMockClient
implements Replayable<ExtensionsAPIGroupDSL>,
Verifiable {
    private final ExtensionsAPIGroupDSL client = (ExtensionsAPIGroupDSL)EasyMock.createMock(ExtensionsAPIGroupDSL.class);
    private MockJobs jobs = new MockJobs();
    private MockDeployment deployments = new MockDeployment();

    public ExtensionsAPIGroupMockClient() {
        EasyMock.expect((Object)this.client.jobs()).andReturn(this.jobs.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.deployments()).andReturn(this.deployments.getDelegate()).anyTimes();
        this.client.close();
        EasyMock.expectLastCall().anyTimes();
    }

    @Override
    public ExtensionsAPIGroupDSL replay() {
        this.jobs.replay();
        this.deployments.replay();
        EasyMock.replay((Object[])new Object[]{this.client});
        return this.client;
    }

    @Override
    public void verify() {
        this.jobs.verify();
        this.deployments.verify();
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    public MockOperation<Job, JobList, MockDoneableJob, MockResource<Job, MockDoneableJob, Boolean>> jobs() {
        return this.jobs;
    }

    public MockOperation<Deployment, DeploymentList, MockDoneableDeployment, MockResource<Deployment, MockDoneableDeployment, Boolean>> deployments() {
        return this.jobs;
    }

    public ExtensionsAPIGroupDSL getDelegate() {
        return this.client;
    }
}

