/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock.impl;

import io.fabric8.kubernetes.api.model.DoneableKubernetesList;
import io.fabric8.kubernetes.api.model.KubernetesList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.dsl.ClientKubernetesListMixedOperation;
import io.fabric8.kubernetes.client.dsl.CreateGettable;
import io.fabric8.kubernetes.client.mock.MockKubernetesListNonNamesapceOperation;
import io.fabric8.kubernetes.client.mock.MockKubernetesListOperation;
import io.fabric8.kubernetes.client.mock.Mockable;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;

public class MockKubernetesListOperationImpl<C extends Client>
implements MockKubernetesListNonNamesapceOperation,
MockKubernetesListOperation,
CreateGettable<KubernetesList, IExpectationSetters<KubernetesList>, DoneableKubernetesList>,
Mockable {
    private final KubernetesListDelegate<C> delegate;
    private final Set<Mockable> nested = new LinkedHashSet<Mockable>();
    private MockKubernetesListOperationImpl loadedMockOp;
    private Map<IArgumentMatcher, MockKubernetesListOperationImpl> namespaceMap = new HashMap<IArgumentMatcher, MockKubernetesListOperationImpl>();

    public IExpectationSetters<Boolean> delete(KubernetesList ... items) {
        return EasyMock.expect((Object)this.delegate.delete(items));
    }

    public IExpectationSetters<Boolean> delete(List<KubernetesList> items) {
        return EasyMock.expect((Object)this.delegate.delete(items));
    }

    public MockKubernetesListOperationImpl() {
        this((KubernetesListDelegate)EasyMock.createMock(KubernetesListDelegate.class));
    }

    public MockKubernetesListOperationImpl(KubernetesListDelegate delegate) {
        this.delegate = delegate;
    }

    @Override
    public Void replay() {
        for (Mockable mockable : this.nested) {
            mockable.replay();
        }
        EasyMock.replay((Object[])new Object[]{this.delegate});
        return null;
    }

    @Override
    public void verify() {
        for (Mockable mockable : this.nested) {
            mockable.verify();
        }
        EasyMock.verify((Object[])new Object[]{this.delegate});
    }

    public MockKubernetesListOperationImpl newInstance() {
        return new MockKubernetesListOperationImpl<C>();
    }

    public KubernetesListDelegate getDelegate() {
        return this.delegate;
    }

    public IExpectationSetters<KubernetesList> create(KubernetesList ... item) {
        return EasyMock.expect((Object)this.delegate.create(item));
    }

    public DoneableKubernetesList createNew() {
        throw new UnsupportedOperationException("Mock client doesn't support inline create. Please use create(T item) instead");
    }

    public CreateGettable<KubernetesList, IExpectationSetters<KubernetesList>, DoneableKubernetesList> load(InputStream input) {
        if (this.loadedMockOp == null) {
            this.loadedMockOp = this.newInstance();
        }
        EasyMock.expect((Object)this.delegate.load(input)).andReturn((Object)this.loadedMockOp.getDelegate()).anyTimes();
        this.nested.add(this.loadedMockOp);
        return this.loadedMockOp;
    }

    public MockKubernetesListNonNamesapceOperation inNamespace(String namespace) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)namespace);
        MockKubernetesListOperationImpl op = this.namespaceMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.inNamespace(namespace)).andReturn((Object)op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public IExpectationSetters<KubernetesList> get() {
        return EasyMock.expect((Object)this.delegate.get());
    }

    private static interface KubernetesListDelegate<C extends Client>
    extends ClientKubernetesListMixedOperation<C>,
    CreateGettable<KubernetesList, KubernetesList, DoneableKubernetesList> {
    }
}

