/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.EditReplaceDeletable;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeletable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.ClientMixedOperation;
import io.fabric8.kubernetes.client.mock.MockDoneable;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.Mockable;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.easymock.internal.matchers.And;

public class BaseMockOperation<C extends Client, T, L extends KubernetesResourceList, D extends Doneable<T>, B extends MockDoneable<T>, R extends ClientResource<T, D>, E extends Resource<T, IExpectationSetters<T>, B, IExpectationSetters<Boolean>>>
implements MockOperation<T, L, B, E>,
MockResource<T, B, Boolean>,
Mockable {
    private final ClientMixedOperation<C, T, L, D, R> delegate;
    private final Set<Mockable> nested = new LinkedHashSet<Mockable>();
    private final Class mockDoneableType;
    private BaseMockOperation loadedMockOp;
    private BaseMockOperation allNamespacesOp;
    private Map<IArgumentMatcher, BaseMockOperation> nameMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> namespaceMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> cascadingMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelNotMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelsNotMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelInsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelNotInMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> fieldMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> filedsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();

    public BaseMockOperation() {
        this((ClientMixedOperation)EasyMock.createMock(ClientMixedOperation.class));
    }

    public BaseMockOperation(ClientMixedOperation delegate) {
        this.delegate = delegate;
        this.mockDoneableType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[4];
    }

    @Override
    public Void replay() {
        for (Mockable mockable : this.nested) {
            mockable.replay();
        }
        EasyMock.replay((Object[])new Object[]{this.delegate});
        return null;
    }

    @Override
    public void verify() {
        for (Mockable mockable : this.nested) {
            mockable.verify();
        }
        EasyMock.verify((Object[])new Object[]{this.delegate});
    }

    public BaseMockOperation newInstance() {
        try {
            return (BaseMockOperation)this.getClass().newInstance();
        }
        catch (Throwable t) {
            throw new RuntimeException();
        }
    }

    public ClientMixedOperation<C, T, L, D, R> getDelegate() {
        return this.delegate;
    }

    public IExpectationSetters<T> create(T ... item) {
        return EasyMock.expect((Object)this.delegate.create((Object[])item));
    }

    public B createNew() {
        MockDoneable mock = null;
        try {
            mock = (MockDoneable)this.mockDoneableType.newInstance();
            EasyMock.expect((Object)this.delegate.createNew()).andReturn(mock.getDelegate()).once();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (mock instanceof Mockable) {
            this.nested.add(mock);
        }
        return (B)mock;
    }

    public IExpectationSetters<Boolean> delete() {
        return EasyMock.expect((Object)this.delegate.delete());
    }

    public B edit() {
        MockDoneable mock = null;
        try {
            mock = (MockDoneable)this.mockDoneableType.newInstance();
            EasyMock.expect((Object)this.delegate.edit()).andReturn(mock.getDelegate()).once();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        if (mock instanceof Mockable) {
            this.nested.add(mock);
        }
        return (B)mock;
    }

    public E withName(String name) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)name);
        BaseMockOperation op = this.nameMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withName(name)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.nameMap.put(matcher, op);
        }
        return (E)op;
    }

    public MockNonNamespaceOperation<T, L, B, E> inNamespace(String namespace) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)namespace);
        BaseMockOperation op = this.namespaceMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.inNamespace(namespace)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public MockNonNamespaceOperation<T, L, B, E> inAnyNamespace() {
        if (this.allNamespacesOp == null) {
            this.allNamespacesOp = this.newInstance();
            EasyMock.expect((Object)this.delegate.inAnyNamespace()).andReturn(this.allNamespacesOp.getDelegate()).anyTimes();
            this.nested.add(this.allNamespacesOp);
        }
        return this.allNamespacesOp;
    }

    public EditReplaceDeletable<T, IExpectationSetters<T>, B, IExpectationSetters<Boolean>> cascading(boolean enabled) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)enabled);
        BaseMockOperation op = this.cascadingMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.cascading(enabled)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public IExpectationSetters<T> update(T item) {
        return this.replace(item);
    }

    public IExpectationSetters<T> replace(T item) {
        return null;
    }

    public IExpectationSetters<T> get() {
        return EasyMock.expect((Object)this.delegate.get());
    }

    public Watch watch(Watcher<IExpectationSetters<T>> watcher) throws KubernetesClientException {
        return this.watch(null, watcher);
    }

    public Watch watch(String resourceVersion, Watcher<IExpectationSetters<T>> watcher) throws KubernetesClientException {
        throw new UnsupportedOperationException();
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabels(Map<String, String> l) {
        IArgumentMatcher matcher = MockUtils.getArgument(l);
        BaseMockOperation op = this.labelsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabels(l)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelsMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withoutLabels(Map<String, String> l) {
        IArgumentMatcher matcher = MockUtils.getArgument(l);
        BaseMockOperation op = this.labelsNotMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withoutLabels(l)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelsNotMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabelIn(String key, String ... values) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument(values);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelInsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabelIn(key, values)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelInsMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabelNotIn(String key, String ... values) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument(values);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelNotInMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabelNotIn(key, values)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelNotInMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabel(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabel(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withoutLabel(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelNotMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withoutLabel(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelNotMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withFields(Map<String, String> f) {
        IArgumentMatcher matcher = MockUtils.getArgument(f);
        BaseMockOperation op = this.filedsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withFields(f)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.filedsMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeletable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withField(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation<C, T, L, D, B, R, E> op = this.fieldMap.get(matcher);
        if (op == null) {
            op = new BaseMockOperation<C, T, L, D, B, R, E>();
            EasyMock.expect((Object)this.delegate.withField(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.fieldMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public IExpectationSetters<L> list() {
        return EasyMock.expect((Object)this.delegate.list());
    }

    public Set<Mockable> getNested() {
        return this.nested;
    }

    public MockResource load(InputStream input) {
        if (this.loadedMockOp == null) {
            this.loadedMockOp = this.newInstance();
        }
        EasyMock.expect((Object)this.delegate.load((Object)input)).andReturn(this.loadedMockOp.getDelegate()).anyTimes();
        this.nested.add(this.loadedMockOp);
        return this.loadedMockOp;
    }

    public IExpectationSetters<Boolean> delete(T ... items) {
        return EasyMock.expect((Object)this.delegate.delete((Object[])items));
    }

    public IExpectationSetters<Boolean> delete(List<T> items) {
        return EasyMock.expect((Object)this.delegate.delete(items));
    }
}

