/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.fabric8.kubernetes.client.mock.impl.donable;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodFluent;
import io.fabric8.kubernetes.api.model.PodFluentImpl;
import io.fabric8.kubernetes.client.mock.MockDoneable;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;

public class MockDoneablePod extends PodFluentImpl<MockDoneablePod> implements MockDoneable<Pod> {

  private interface DelegateInterface extends Doneable<Pod>, PodFluent<DoneablePod>{}
  private final Visitor<Pod> visitor = new Visitor<Pod>() {
    @Override
    public void visit(Pod pod) {
    }
  };

  private final DoneablePod delegate;

  public MockDoneablePod() {
    this.delegate = EasyMock.createMock(DoneablePod .class);
  }

  @Override
  public IExpectationSetters<Pod> done() {
    return EasyMock.expect(delegate.done());
  }

  @Override
  public Void replay() {
    EasyMock.replay(delegate);
    return null;
  }

  @Override
  public void verify() {
    EasyMock.verify(delegate);
  }

  @Override
  public Doneable<Pod> getDelegate() {
    return new DoneablePod(visitor) {
      @Override
      public Pod done() {
        return delegate.done();
      }
    };
  }
}
