/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock.util;

import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.mock.util.WrappedMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.internal.LastControl;
import org.easymock.internal.MocksBehavior;
import org.easymock.internal.MocksControl;
import org.easymock.internal.RecordState;
import org.easymock.internal.UnorderedBehavior;
import org.easymock.internal.matchers.And;
import org.easymock.internal.matchers.Equals;

public class MockUtils {
    public static IArgumentMatcher getArgument(Object argument) {
        if (argument == null) {
            List matchers = LastControl.pullMatchers();
            if (matchers == null || matchers.isEmpty()) {
                return null;
            }
            for (IArgumentMatcher m : matchers) {
                LastControl.reportMatcher((IArgumentMatcher)m);
            }
            return WrappedMatcher.wrap((IArgumentMatcher)matchers.get(0));
        }
        if (argument instanceof IArgumentMatcher) {
            return WrappedMatcher.wrap((IArgumentMatcher)argument);
        }
        return new WrappedMatcher((IArgumentMatcher)new Equals(argument));
    }

    public static IArgumentMatcher getArgument(Object ... args) {
        ArrayList<IArgumentMatcher> matchers = new ArrayList<IArgumentMatcher>();
        for (Object o : args) {
            matchers.add(MockUtils.getArgument(o));
        }
        return new And(matchers);
    }

    public static MocksControl getControl(Object mock) {
        try {
            Method m = EasyMock.class.getDeclaredMethod("getControl", Object.class);
            m.setAccessible(true);
            return (MocksControl)m.invoke(null, mock);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private static MocksBehavior getBehavior(RecordState state) {
        try {
            Field f = RecordState.class.getDeclaredField("behavior");
            f.setAccessible(true);
            return (MocksBehavior)f.get(state);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private static List<UnorderedBehavior> getBehaviorList(MocksBehavior behavior) {
        try {
            Field f = MocksBehavior.class.getDeclaredField("behaviorLists");
            f.setAccessible(true);
            return (List)f.get(behavior);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    private List getBehaviorList(RecordState state) {
        try {
            Field f = RecordState.class.getDeclaredField("behavior");
            f.setAccessible(true);
            MocksBehavior behavior = (MocksBehavior)f.get(state);
            f = MocksBehavior.class.getDeclaredField("behaviorLists");
            f.setAccessible(true);
            List list = (List)f.get(behavior);
            return list;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }
}

