/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import io.fabric8.kubernetes.api.model.DoneableEndpoints;
import io.fabric8.kubernetes.api.model.DoneableEvent;
import io.fabric8.kubernetes.api.model.DoneableNamespace;
import io.fabric8.kubernetes.api.model.DoneableNode;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolume;
import io.fabric8.kubernetes.api.model.DoneablePersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.DoneablePod;
import io.fabric8.kubernetes.api.model.DoneableReplicationController;
import io.fabric8.kubernetes.api.model.DoneableResourceQuota;
import io.fabric8.kubernetes.api.model.DoneableSecret;
import io.fabric8.kubernetes.api.model.DoneableSecurityContextConstraints;
import io.fabric8.kubernetes.api.model.DoneableService;
import io.fabric8.kubernetes.api.model.DoneableServiceAccount;
import io.fabric8.kubernetes.api.model.Endpoints;
import io.fabric8.kubernetes.api.model.EndpointsList;
import io.fabric8.kubernetes.api.model.Event;
import io.fabric8.kubernetes.api.model.EventList;
import io.fabric8.kubernetes.api.model.Namespace;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.Node;
import io.fabric8.kubernetes.api.model.NodeList;
import io.fabric8.kubernetes.api.model.PersistentVolume;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimList;
import io.fabric8.kubernetes.api.model.PersistentVolumeList;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.ReplicationControllerList;
import io.fabric8.kubernetes.api.model.ResourceQuota;
import io.fabric8.kubernetes.api.model.ResourceQuotaList;
import io.fabric8.kubernetes.api.model.RootPaths;
import io.fabric8.kubernetes.api.model.Secret;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.api.model.SecurityContextConstraints;
import io.fabric8.kubernetes.api.model.SecurityContextConstraintsList;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceAccount;
import io.fabric8.kubernetes.api.model.ServiceAccountList;
import io.fabric8.kubernetes.api.model.ServiceList;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.mock.MockKubernetesListOperation;
import io.fabric8.kubernetes.client.mock.MockLoggableResource;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.MockResource;
import io.fabric8.kubernetes.client.mock.MockRollableScaleableResource;
import io.fabric8.kubernetes.client.mock.Replayable;
import io.fabric8.kubernetes.client.mock.Verifiable;
import io.fabric8.kubernetes.client.mock.impl.MockEndpoints;
import io.fabric8.kubernetes.client.mock.impl.MockEvent;
import io.fabric8.kubernetes.client.mock.impl.MockKubernetesListOperationImpl;
import io.fabric8.kubernetes.client.mock.impl.MockNamespace;
import io.fabric8.kubernetes.client.mock.impl.MockNode;
import io.fabric8.kubernetes.client.mock.impl.MockPersistentVolume;
import io.fabric8.kubernetes.client.mock.impl.MockPersistentVolumeClaim;
import io.fabric8.kubernetes.client.mock.impl.MockPod;
import io.fabric8.kubernetes.client.mock.impl.MockReplicationController;
import io.fabric8.kubernetes.client.mock.impl.MockResourceQuota;
import io.fabric8.kubernetes.client.mock.impl.MockSecret;
import io.fabric8.kubernetes.client.mock.impl.MockSecurityContextConstraints;
import io.fabric8.kubernetes.client.mock.impl.MockService;
import io.fabric8.kubernetes.client.mock.impl.MockServiceAccount;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;

public class KubernetesMockClient
implements Replayable<KubernetesClient>,
Verifiable {
    private final KubernetesClient client = (KubernetesClient)EasyMock.createMock(KubernetesClient.class);
    private KubernetesMockClient anyNamespaceOp;
    private Map<IArgumentMatcher, KubernetesMockClient> namespaceMap = new HashMap<IArgumentMatcher, KubernetesMockClient>();
    private final MockEndpoints endpoints = new MockEndpoints();
    private final MockEvent events = new MockEvent();
    private final MockNode nodes = new MockNode();
    private final MockNamespace namespaces = new MockNamespace();
    private final MockPersistentVolume persistentVolumes = new MockPersistentVolume();
    private final MockPersistentVolumeClaim persistentVolumeClaims = new MockPersistentVolumeClaim();
    private final MockPod pods = new MockPod();
    private final MockService services = new MockService();
    private final MockReplicationController replicationControllers = new MockReplicationController();
    private final MockResourceQuota resourceQuotas = new MockResourceQuota();
    private final MockSecret secrets = new MockSecret();
    private final MockServiceAccount serviceAccounts = new MockServiceAccount();
    private final MockSecurityContextConstraints securityContextConstraints = new MockSecurityContextConstraints();
    private final MockKubernetesListOperationImpl kubernetesLists = new MockKubernetesListOperationImpl();

    public KubernetesMockClient() {
        EasyMock.expect((Object)this.client.endpoints()).andReturn(this.endpoints.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.events()).andReturn(this.events.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.nodes()).andReturn(this.nodes.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.namespaces()).andReturn(this.namespaces.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.persistentVolumes()).andReturn(this.persistentVolumes.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.persistentVolumeClaims()).andReturn(this.persistentVolumeClaims.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.pods()).andReturn(this.pods.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.services()).andReturn(this.services.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.replicationControllers()).andReturn(this.replicationControllers.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.resourceQuotas()).andReturn(this.resourceQuotas.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.secrets()).andReturn(this.secrets.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.serviceAccounts()).andReturn(this.serviceAccounts.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.securityContextConstraints()).andReturn(this.securityContextConstraints.getDelegate()).anyTimes();
        EasyMock.expect((Object)this.client.lists()).andReturn((Object)this.kubernetesLists.getDelegate()).anyTimes();
        this.client.close();
        EasyMock.expectLastCall().anyTimes();
    }

    @Override
    public KubernetesClient replay() {
        this.endpoints.replay();
        this.events.replay();
        this.nodes.replay();
        this.namespaces.replay();
        this.persistentVolumes.replay();
        this.persistentVolumeClaims.replay();
        this.pods.replay();
        this.services.replay();
        this.replicationControllers.replay();
        this.resourceQuotas.replay();
        this.secrets.replay();
        this.serviceAccounts.replay();
        this.securityContextConstraints.replay();
        this.kubernetesLists.replay();
        EasyMock.replay((Object[])new Object[]{this.client});
        return this.client;
    }

    @Override
    public void verify() {
        this.endpoints.verify();
        this.events.verify();
        this.nodes.verify();
        this.namespaces.verify();
        this.persistentVolumes.verify();
        this.persistentVolumeClaims.verify();
        this.pods.verify();
        this.services.verify();
        this.replicationControllers.verify();
        this.resourceQuotas.verify();
        this.secrets.verify();
        this.serviceAccounts.verify();
        this.securityContextConstraints.verify();
        this.kubernetesLists.verify();
        EasyMock.verify((Object[])new Object[]{this.client});
    }

    public IExpectationSetters<URL> getMasterUrl() {
        return EasyMock.expect((Object)this.client.getMasterUrl());
    }

    public IExpectationSetters<Config> getConfiguration() {
        return EasyMock.expect((Object)this.client.getConfiguration());
    }

    public IExpectationSetters<RootPaths> rootPaths() {
        return EasyMock.expect((Object)this.client.rootPaths());
    }

    public MockOperation<Endpoints, EndpointsList, DoneableEndpoints, MockResource<Endpoints, DoneableEndpoints, Boolean>> endpoints() {
        return this.endpoints;
    }

    public MockOperation<Event, EventList, DoneableEvent, MockResource<Event, DoneableEvent, Boolean>> events() {
        return this.events;
    }

    public MockOperation<Namespace, NamespaceList, DoneableNamespace, MockResource<Namespace, DoneableNamespace, Boolean>> namespaces() {
        return this.namespaces;
    }

    public MockOperation<Node, NodeList, DoneableNode, MockResource<Node, DoneableNode, Boolean>> nodes() {
        return this.nodes;
    }

    public MockOperation<PersistentVolume, PersistentVolumeList, DoneablePersistentVolume, MockResource<PersistentVolume, DoneablePersistentVolume, Boolean>> persistentVolumes() {
        return this.persistentVolumes;
    }

    public MockOperation<PersistentVolumeClaim, PersistentVolumeClaimList, DoneablePersistentVolumeClaim, MockResource<PersistentVolumeClaim, DoneablePersistentVolumeClaim, Boolean>> persistentVolumeClaims() {
        return this.persistentVolumeClaims;
    }

    public MockOperation<Pod, PodList, DoneablePod, MockLoggableResource<Pod, DoneablePod, Boolean>> pods() {
        return this.pods;
    }

    public MockOperation<ReplicationController, ReplicationControllerList, DoneableReplicationController, MockRollableScaleableResource<ReplicationController, DoneableReplicationController, Boolean>> replicationControllers() {
        return this.replicationControllers;
    }

    public MockOperation<ResourceQuota, ResourceQuotaList, DoneableResourceQuota, MockResource<ResourceQuota, DoneableResourceQuota, Boolean>> resourceQuotas() {
        return this.resourceQuotas;
    }

    public MockOperation<Secret, SecretList, DoneableSecret, MockResource<Secret, DoneableSecret, Boolean>> secrets() {
        return this.secrets;
    }

    public MockOperation<Service, ServiceList, DoneableService, MockResource<Service, DoneableService, Boolean>> services() {
        return this.services;
    }

    public MockOperation<ServiceAccount, ServiceAccountList, DoneableServiceAccount, MockResource<ServiceAccount, DoneableServiceAccount, Boolean>> serviceAccounts() {
        return this.serviceAccounts;
    }

    public MockOperation<SecurityContextConstraints, SecurityContextConstraintsList, DoneableSecurityContextConstraints, MockResource<SecurityContextConstraints, DoneableSecurityContextConstraints, Boolean>> securityContextConstraints() {
        return this.securityContextConstraints;
    }

    public MockKubernetesListOperation lists() {
        return this.kubernetesLists;
    }

    public KubernetesMockClient inNamespace(String namespace) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)namespace);
        KubernetesMockClient op = this.namespaceMap.get(matcher);
        if (op == null) {
            KubernetesMockClient namespacedClient;
            op = namespacedClient = new KubernetesMockClient();
            EasyMock.expect((Object)this.client.inNamespace(namespace)).andAnswer((IAnswer)new IAnswer<KubernetesClient>(){

                public KubernetesClient answer() throws Throwable {
                    return namespacedClient.replay();
                }
            }).anyTimes();
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public KubernetesMockClient inAnyNamespace() {
        if (this.anyNamespaceOp == null) {
            KubernetesMockClient namespacedClient;
            this.anyNamespaceOp = namespacedClient = new KubernetesMockClient();
            EasyMock.expect((Object)this.client.inAnyNamespace()).andAnswer((IAnswer)new IAnswer<KubernetesClient>(){

                public KubernetesClient answer() throws Throwable {
                    return namespacedClient.replay();
                }
            }).anyTimes();
        }
        return this.anyNamespaceOp;
    }

    public <T extends Client> IExpectationSetters<T> adapt(Class<T> type) {
        return EasyMock.expect((Object)this.client.adapt(type));
    }
}

