/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.mock;

import com.ning.http.client.ws.WebSocket;
import io.fabric8.kubernetes.api.model.Doneable;
import io.fabric8.kubernetes.api.model.KubernetesResourceList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.ClientMixedOperation;
import io.fabric8.kubernetes.client.dsl.ClientResource;
import io.fabric8.kubernetes.client.dsl.FilterWatchListDeleteable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.mock.MockNonNamespaceOperation;
import io.fabric8.kubernetes.client.mock.MockOperation;
import io.fabric8.kubernetes.client.mock.Mockable;
import io.fabric8.kubernetes.client.mock.util.MockUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.easymock.EasyMock;
import org.easymock.IArgumentMatcher;
import org.easymock.IExpectationSetters;
import org.easymock.internal.matchers.And;

public class BaseMockOperation<C extends KubernetesClient, T, L extends KubernetesResourceList, D extends Doneable<T>, R extends ClientResource<T, D>, E extends Resource<T, IExpectationSetters<T>, D, IExpectationSetters<Boolean>>>
implements MockOperation<T, L, D, E>,
Mockable {
    private final ClientMixedOperation<C, T, L, D, R> delegate;
    private final Set<Mockable> nested = new LinkedHashSet<Mockable>();
    private Map<IArgumentMatcher, BaseMockOperation> nameMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> namespaceMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelNotMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelsNotMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelInsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> labelNotInMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> fieldMap = new HashMap<IArgumentMatcher, BaseMockOperation>();
    private Map<IArgumentMatcher, BaseMockOperation> filedsMap = new HashMap<IArgumentMatcher, BaseMockOperation>();

    public BaseMockOperation() {
        this((ClientMixedOperation)EasyMock.createMock(ClientMixedOperation.class));
    }

    public BaseMockOperation(ClientMixedOperation delegate) {
        this.delegate = delegate;
    }

    @Override
    public Void replay() {
        for (Mockable mockable : this.nested) {
            mockable.replay();
        }
        EasyMock.replay((Object[])new Object[]{this.delegate});
        return null;
    }

    @Override
    public void verify() {
        for (Mockable mockable : this.nested) {
            mockable.verify();
        }
        EasyMock.verify((Object[])new Object[]{this.delegate});
    }

    public BaseMockOperation newInstance() {
        return new BaseMockOperation<C, T, L, D, R, E>();
    }

    public ClientMixedOperation<C, T, L, D, R> getDelegate() {
        return this.delegate;
    }

    public IExpectationSetters<T> create(T item) {
        return EasyMock.expect((Object)this.delegate.create(EasyMock.eq(item)));
    }

    public D createNew() {
        throw new UnsupportedOperationException("Mock client doesn't support inline create. Please use create(T item) instead");
    }

    public IExpectationSetters<Boolean> delete() {
        return EasyMock.expect((Object)this.delegate.delete(true));
    }

    public IExpectationSetters<Boolean> delete(boolean cascade) {
        return EasyMock.expect((Object)this.delegate.delete(cascade));
    }

    public D edit() {
        return this.edit(true);
    }

    public D edit(boolean cascade) {
        throw new UnsupportedOperationException("Mock client doesn't support inline edit. Please use replace(T item) instead.");
    }

    public E withName(String name) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)name);
        BaseMockOperation op = this.nameMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withName(name)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.nameMap.put(matcher, op);
        }
        return (E)op;
    }

    public MockNonNamespaceOperation<T, L, D, E> inNamespace(String namespace) {
        IArgumentMatcher matcher = MockUtils.getArgument((Object)namespace);
        BaseMockOperation op = this.namespaceMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.inNamespace(namespace)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.namespaceMap.put(matcher, op);
        }
        return op;
    }

    public IExpectationSetters<T> update(T item) {
        return this.replace(item);
    }

    public IExpectationSetters<T> update(T item, boolean cascade) {
        return this.replace(item, cascade);
    }

    public IExpectationSetters<T> replace(T item) {
        return this.replace(item, true);
    }

    public IExpectationSetters<T> replace(T item, boolean cascade) {
        return null;
    }

    public IExpectationSetters<T> get() {
        return EasyMock.expect((Object)this.delegate.get());
    }

    public WebSocket watch(Watcher<IExpectationSetters<T>> watcher) throws KubernetesClientException {
        throw new UnsupportedOperationException();
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabels(Map<String, String> l) {
        IArgumentMatcher matcher = MockUtils.getArgument(l);
        BaseMockOperation op = this.labelsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabels(l)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelsMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withoutLabels(Map<String, String> l) {
        IArgumentMatcher matcher = MockUtils.getArgument(l);
        BaseMockOperation op = this.labelsNotMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withoutLabels(l)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelsNotMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabelIn(String key, String ... values) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument(values);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelInsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabelIn(key, values)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelInsMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabelNotIn(String key, String ... values) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument(values);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelNotInMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabelNotIn(key, values)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelNotInMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withLabel(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withLabel(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withoutLabel(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation op = this.labelNotMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withoutLabel(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.labelNotMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withFields(Map<String, String> f) {
        IArgumentMatcher matcher = MockUtils.getArgument(f);
        BaseMockOperation op = this.filedsMap.get(matcher);
        if (op == null) {
            op = this.newInstance();
            EasyMock.expect((Object)this.delegate.withFields(f)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.filedsMap.put(matcher, op);
        }
        return op;
    }

    public FilterWatchListDeleteable<IExpectationSetters<T>, IExpectationSetters<L>, IExpectationSetters<Boolean>> withField(String key, String value) {
        IArgumentMatcher keyMatcher = MockUtils.getArgument((Object)key);
        IArgumentMatcher valueMatcher = MockUtils.getArgument((Object)value);
        And matcher = new And(Arrays.asList(keyMatcher, valueMatcher));
        BaseMockOperation<C, T, L, D, R, E> op = this.fieldMap.get(matcher);
        if (op == null) {
            op = new BaseMockOperation<C, T, L, D, R, E>();
            EasyMock.expect((Object)this.delegate.withField(key, value)).andReturn(op.getDelegate()).anyTimes();
            this.nested.add(op);
            this.fieldMap.put((IArgumentMatcher)matcher, op);
        }
        return op;
    }

    public IExpectationSetters<L> list() {
        return EasyMock.expect((Object)this.delegate.list());
    }

    public Set<Mockable> getNested() {
        return this.nested;
    }
}

