/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.mbeans;

import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.mbeans.AppPodSummaryDTO;
import io.fabric8.kubernetes.mbeans.AppReplicationControllerSummaryDTO;
import io.fabric8.kubernetes.mbeans.AppServiceSummaryDTO;
import io.fabric8.kubernetes.mbeans.AppSummaryDTO;
import io.fabric8.kubernetes.mbeans.AppViewSnapshot;
import io.fabric8.utils.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AppViewDetails {
    private final AppViewSnapshot snapshot;
    private final String appPath;
    private final String namespace;
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final Map<String, ReplicationController> controllers = new HashMap<String, ReplicationController>();
    private final Map<String, Pod> pods = new HashMap<String, Pod>();

    public AppViewDetails(AppViewSnapshot snapshot, String appPath, String namespace) {
        this.snapshot = snapshot;
        this.appPath = appPath;
        this.namespace = namespace;
    }

    public AppViewSnapshot getSnapshot() {
        return this.snapshot;
    }

    public String getAppPath() {
        return this.appPath;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public Map<String, ReplicationController> getControllers() {
        return this.controllers;
    }

    public Map<String, Pod> getPods() {
        return this.pods;
    }

    public void addService(Service service) {
        String id = KubernetesHelper.getId((Service)service);
        if (Strings.isNotBlank((String)id)) {
            this.services.put(id, service);
        }
    }

    public void addController(ReplicationController controller) {
        String id = KubernetesHelper.getId((ReplicationController)controller);
        if (Strings.isNotBlank((String)id)) {
            this.controllers.put(id, controller);
            List<Pod> pods = this.snapshot.podsForReplicationController(controller);
            for (Pod pod : pods) {
                this.addPod(pod);
            }
        }
    }

    public void addPod(Pod pod) {
        String id = KubernetesHelper.getId((Pod)pod);
        if (Strings.isNotBlank((String)id)) {
            this.pods.put(id, pod);
        }
    }

    public AppSummaryDTO getSummary() {
        AppSummaryDTO answer = new AppSummaryDTO(this.appPath, this.namespace);
        for (Service service : this.getServices().values()) {
            answer.addServiceSummary(new AppServiceSummaryDTO(service));
        }
        for (ReplicationController controller : this.getControllers().values()) {
            answer.addReplicationControllerSummary(new AppReplicationControllerSummaryDTO(controller));
        }
        for (Pod pod : this.getPods().values()) {
            answer.addPodSummary(new AppPodSummaryDTO(pod));
        }
        return answer;
    }
}

