/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.mbeans;

import io.fabric8.kubernetes.api.Controller;
import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesClient;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodState;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.kubernetes.api.model.ReplicationController;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.mbeans.KubernetesManagerMXBean;
import io.fabric8.utils.JMXUtils;
import io.fabric8.utils.Strings;
import java.io.IOException;
import java.util.Map;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class KubernetesManager
implements KubernetesManagerMXBean {
    public static ObjectName OBJECT_NAME;
    private KubernetesClient kubernetes = new KubernetesClient();

    public void init() {
        JMXUtils.registerMBean((Object)this, (ObjectName)OBJECT_NAME);
    }

    public void destroy() {
        JMXUtils.unregisterMBean((ObjectName)OBJECT_NAME);
    }

    @Override
    public String apply(String json) throws IOException {
        Controller controller = this.createController();
        return controller.applyJson(json);
    }

    @Override
    public String getServiceUrl(String serviceName) {
        Map serviceMap = KubernetesHelper.getServiceMap((Kubernetes)this.kubernetes);
        Service service = (Service)serviceMap.get(serviceName);
        return KubernetesHelper.getServiceURL((Service)service);
    }

    @Override
    public String getPodUrl(String name, String portNumberOrName) {
        PodState currentState;
        Map podMap = KubernetesHelper.getPodMap((Kubernetes)this.kubernetes);
        Pod pod = (Pod)podMap.get(name);
        if (pod != null && (currentState = pod.getCurrentState()) != null) {
            String protocol = "http://";
            Port port = KubernetesHelper.findContainerPortByNumberOrName((Pod)pod, (String)portNumberOrName);
            Integer containerPort = port != null ? port.getContainerPort() : null;
            String podIP = currentState.getPodIP();
            if (Strings.isNotBlank((String)podIP)) {
                return this.addPortToIP(protocol + podIP, containerPort, portNumberOrName);
            }
            String host = currentState.getHost();
            if (Strings.isNotBlank((String)host)) {
                return this.addPortToIP(protocol + host, port != null ? port.getHostPort() : null, portNumberOrName);
            }
        }
        return null;
    }

    protected String addPortToIP(String podIP, Integer containerPort, String portNumberOrName) {
        if (containerPort != null && containerPort > 0 && containerPort != 80) {
            return podIP + ":" + containerPort;
        }
        if (Strings.isNotBlank((String)portNumberOrName)) {
            return podIP + ":" + portNumberOrName;
        }
        return podIP;
    }

    @Override
    public String getDockerRegistry() {
        String answer = System.getenv("DOCKER_REGISTRY");
        if (Strings.isNotBlank((String)answer) && !answer.contains("://")) {
            answer = "http://" + answer;
        }
        if (Strings.isNullOrBlank((String)answer)) {
            String registryHost = System.getenv("REGISTRY_SERVICE_HOST");
            String registryPort = System.getenv("REGISTRY_SERVICE_PORT");
            if (Strings.isNotBlank((String)registryHost) && Strings.isNotBlank((String)registryPort)) {
                return registryHost + ":" + registryPort;
            }
        }
        return answer;
    }

    @Override
    public String getReplicationControllerIdForPod(String podId) {
        ReplicationController replicationController = this.kubernetes.getReplicationControllerForPod(podId);
        if (replicationController != null) {
            return KubernetesHelper.getId((ReplicationController)replicationController);
        }
        return null;
    }

    public KubernetesClient getKubernetes() {
        return this.kubernetes;
    }

    public void setKubernetes(KubernetesClient kubernetes) {
        this.kubernetes = kubernetes;
    }

    protected Controller createController() {
        return new Controller(this.kubernetes);
    }

    static {
        try {
            OBJECT_NAME = new ObjectName("io.fabric8:type=KubernetesManager");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            // empty catch block
        }
    }
}

