/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.log4j.lookup;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.status.StatusLogger;

final class ContainerUtil {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private static final Pattern DOCKER_ID_PATTERN = Pattern.compile("[0-9a-fA-F]{64}");
    static final Path CGROUP_PATH = Paths.get("/proc/self/cgroup", new String[0]);

    private ContainerUtil() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getContainerId(Path path) {
        try {
            if (!Files.exists(path, new LinkOption[0])) {
                LOGGER.warn("Unable to access container information");
                return null;
            }
            try (Stream<String> lines = Files.lines(path);){
                String id = lines.map(ContainerUtil::getContainerId).filter(Objects::nonNull).findFirst().orElse(null);
                LOGGER.debug("Found container id {}", (Object)id);
                String string = id;
                return string;
            }
        }
        catch (IOException ioe) {
            LOGGER.warn("Error obtaining container id: {}", (Object)ioe.getMessage());
        }
        return null;
    }

    private static String getContainerId(String line) {
        return Optional.ofNullable(ContainerUtil.getCGroupPath(line)).map(ContainerUtil::getDockerId).orElse(null);
    }

    private static String getDockerId(String cgroupPath) {
        String[] elements = cgroupPath.split("/", -1);
        String dockerId = null;
        for (String element : elements) {
            Matcher matcher = DOCKER_ID_PATTERN.matcher(element);
            if (!matcher.find()) continue;
            dockerId = matcher.group();
        }
        return dockerId;
    }

    private static String getCGroupPath(String line) {
        String[] fields = line.split(":", -1);
        return fields.length > 2 ? fields[2] : null;
    }
}

