/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.jolokia;

import io.fabric8.kubernetes.api.Kubernetes;
import io.fabric8.kubernetes.api.KubernetesFactory;
import io.fabric8.kubernetes.api.KubernetesHelper;
import io.fabric8.kubernetes.api.model.CurrentState;
import io.fabric8.kubernetes.api.model.DetailInfo;
import io.fabric8.kubernetes.api.model.ManifestContainer;
import io.fabric8.kubernetes.api.model.PodCurrentContainerInfo;
import io.fabric8.kubernetes.api.model.PodSchema;
import io.fabric8.kubernetes.api.model.Port;
import io.fabric8.utils.Strings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.jolokia.client.J4pClient;
import org.jolokia.client.J4pClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JolokiaClients {
    private static final transient Logger LOG = LoggerFactory.getLogger(JolokiaClients.class);
    private final Kubernetes kubernetes;
    private String user;
    private String password;

    public JolokiaClients() {
        this(new KubernetesFactory().createKubernetes());
    }

    public JolokiaClients(Kubernetes kubernetes) {
        this.kubernetes = kubernetes;
    }

    public Kubernetes getKubernetes() {
        return this.kubernetes;
    }

    public J4pClient jolokiaClient(String host, ManifestContainer container, PodSchema pod) {
        if (container != null) {
            List ports = container.getPorts();
            for (Port port : ports) {
                String dockerIp;
                Integer containerPort = port.getContainerPort();
                if (containerPort == null) continue;
                String name = port.getName();
                if (containerPort != 8778 && (!Objects.equals("jolokia", name) || containerPort <= 0)) continue;
                CurrentState currentState = pod.getCurrentState();
                String podIP = currentState.getPodIP();
                if (Strings.isNotBlank((String)podIP)) {
                    return this.createJolokiaClientFromHostAndPort(container, podIP, containerPort);
                }
                Integer hostPort = port.getHostPort();
                if (hostPort != null && this.hasDocker(pod) && (host.equals("localhost") || host.equals("127.0.0.1")) && Strings.isNotBlank((String)(dockerIp = KubernetesHelper.getDockerIp()))) {
                    host = dockerIp;
                }
                if (!Strings.isNotBlank((String)host)) continue;
                return this.createJolokiaClientFromHostAndPort(container, host, hostPort);
            }
        }
        return null;
    }

    protected J4pClient createJolokiaClientFromHostAndPort(ManifestContainer container, String host, Integer hostPort) {
        String jolokiaUrl = "http://" + host + ":" + hostPort + "/jolokia/";
        return this.createJolokiaClient(container, jolokiaUrl);
    }

    protected boolean hasDocker(PodSchema pod) {
        Map info;
        CurrentState currentState = pod.getCurrentState();
        if (currentState != null && (info = currentState.getInfo()) != null) {
            Collection containers = info.values();
            for (PodCurrentContainerInfo container : containers) {
                Map additionalProperties;
                DetailInfo detailInfo = container.getDetailInfo();
                if (detailInfo == null || (additionalProperties = detailInfo.getAdditionalProperties()) == null || !additionalProperties.containsKey("HostConfig")) continue;
                return true;
            }
        }
        return false;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    protected J4pClient createJolokiaClient(ManifestContainer container, String jolokiaUrl) {
        String name = container.getName();
        LOG.info("Creating jolokia client for : " + name + " at URL: " + jolokiaUrl);
        J4pClientBuilder builder = J4pClient.url((String)jolokiaUrl);
        if (Strings.isNotBlank((String)this.user)) {
            builder = builder.user(this.user);
        }
        if (Strings.isNotBlank((String)this.password)) {
            builder = builder.password(this.password);
        }
        return builder.build();
    }
}

