/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.http.WebSocketUpgradeResponse;
import io.fabric8.kubernetes.client.vertx.VertxHttpClientBuilder;
import io.fabric8.kubernetes.client.vertx.VertxHttpRequest;
import io.fabric8.kubernetes.client.vertx.VertxWebSocket;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.ext.web.client.WebClientOptions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public class VertxHttpClient<F extends HttpClient.Factory>
extends StandardHttpClient<VertxHttpClient<F>, F, VertxHttpClientBuilder<F>> {
    private final List<VertxHttpClient<F>> derivedClients = Collections.synchronizedList(new ArrayList());
    private final Vertx vertx;
    private final HttpClient client;
    private final String proxyAuthorization;

    VertxHttpClient(VertxHttpClientBuilder<F> vertxHttpClientBuilder, WebClientOptions options, String proxyAuthorization) {
        super(vertxHttpClientBuilder);
        this.vertx = vertxHttpClientBuilder.vertx;
        this.client = this.vertx.createHttpClient((HttpClientOptions)options);
        this.proxyAuthorization = proxyAuthorization;
    }

    public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
        WebSocketConnectOptions options = new WebSocketConnectOptions();
        if (this.builder.getReadTimeout() != null) {
            options.setTimeout(this.builder.getReadTimeout().toMillis());
        }
        if (standardWebSocketBuilder.getSubprotocol() != null) {
            options.setSubProtocols(Collections.singletonList(standardWebSocketBuilder.getSubprotocol()));
        }
        StandardHttpRequest request = standardWebSocketBuilder.asHttpRequest();
        request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> options.addHeader((String)e.getKey(), v)));
        options.setAbsoluteURI(request.uri().toString());
        CompletableFuture<WebSocketResponse> response = new CompletableFuture<WebSocketResponse>();
        this.client.webSocket(options).onSuccess(ws -> {
            VertxWebSocket ret = new VertxWebSocket((WebSocket)ws, listener);
            ret.init();
            response.complete(new WebSocketResponse(new WebSocketUpgradeResponse((HttpRequest)request), (io.fabric8.kubernetes.client.http.WebSocket)ret));
        }).onFailure(t -> {
            if (t instanceof UpgradeRejectedException) {
                UpgradeRejectedException handshake = (UpgradeRejectedException)t;
                WebSocketUpgradeResponse upgradeResponse = new WebSocketUpgradeResponse((HttpRequest)request, handshake.getStatus(), VertxHttpRequest.toHeadersMap(handshake.getHeaders()));
                response.complete(new WebSocketResponse(upgradeResponse, (Throwable)handshake));
            }
            response.completeExceptionally((Throwable)t);
        });
        return response;
    }

    public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
        RequestOptions options = new RequestOptions();
        request.headers().forEach((k, l) -> l.forEach(v -> options.addHeader(k, v)));
        options.setAbsoluteURI(request.uri().toString());
        options.setMethod(HttpMethod.valueOf((String)request.method()));
        if (this.proxyAuthorization != null) {
            options.putHeader(HttpHeaders.PROXY_AUTHORIZATION, (CharSequence)this.proxyAuthorization);
        }
        Optional.ofNullable(request.getContentType()).ifPresent(s -> options.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)s));
        if (request.isExpectContinue()) {
            options.putHeader(HttpHeaders.EXPECT, HttpHeaders.CONTINUE);
        }
        return new VertxHttpRequest(this.vertx, options, request).consumeBytes(this.client, consumer);
    }

    void addDerivedClient(VertxHttpClient<F> client) {
        this.derivedClients.add(client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.client.close();
        List<VertxHttpClient<F>> list = this.derivedClients;
        synchronized (list) {
            this.derivedClients.forEach(VertxHttpClient::close);
            this.derivedClients.clear();
        }
    }
}

