/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.vertx.VertxHttpClient;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import io.vertx.ext.web.client.WebClientOptions;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class VertxHttpClientBuilder<F extends HttpClient.Factory>
extends StandardHttpClientBuilder<VertxHttpClient<F>, F, VertxHttpClientBuilder<F>> {
    private static final int MAX_CONNECTIONS = 8192;
    private static final int MAX_WS_MESSAGE_SIZE = Integer.MAX_VALUE;
    final Vertx vertx;

    public VertxHttpClientBuilder(F clientFactory, Vertx vertx) {
        super(clientFactory);
        this.vertx = vertx;
    }

    public VertxHttpClient<F> build() {
        WebClientOptions options = new WebClientOptions();
        options.setMaxPoolSize(8192);
        options.setMaxWebSockets(8192);
        options.setIdleTimeoutUnit(TimeUnit.SECONDS);
        options.setMaxWebSocketFrameSize(Integer.MAX_VALUE);
        options.setMaxWebSocketMessageSize(Integer.MAX_VALUE);
        if (this.connectTimeout != null) {
            options.setConnectTimeout((int)this.connectTimeout.toMillis());
        }
        if (this.writeTimeout != null) {
            options.setWriteIdleTimeout((int)this.writeTimeout.getSeconds());
        }
        if (this.followRedirects) {
            options.setFollowRedirects(this.followRedirects);
        }
        if (this.proxyAddress != null) {
            ProxyOptions proxyOptions = new ProxyOptions().setHost(this.proxyAddress.getHostName()).setPort(this.proxyAddress.getPort()).setType(ProxyType.HTTP);
            options.setProxyOptions(proxyOptions);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            Stream.of(this.tlsVersions).map(TlsVersion::javaName).forEach(arg_0 -> ((WebClientOptions)options).addEnabledSecureTransportProtocol(arg_0));
        }
        if (this.preferHttp11) {
            options.setProtocolVersion(HttpVersion.HTTP_1_1);
        }
        if (this.sslContext != null) {
            options.setSsl(true);
            options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

                public JdkSSLEngineOptions copy() {
                    return this;
                }

                public SslContextFactory sslContextFactory() {
                    return () -> new JdkSslContext(VertxHttpClientBuilder.this.sslContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                }
            });
        }
        VertxHttpClient result = new VertxHttpClient(this, options, this.proxyAddress != null ? this.proxyAuthorization : null);
        if (this.client != null) {
            ((VertxHttpClient)this.client).addDerivedClient(result);
        }
        return result;
    }

    protected VertxHttpClientBuilder<F> newInstance(F clientFactory) {
        return new VertxHttpClientBuilder<F>(clientFactory, this.vertx);
    }
}

