/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.vertx.VertxHttpRequest;
import io.netty.buffer.ByteBuf;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import java.io.IOException;
import java.io.InputStream;

class InputStreamReadStream
implements ReadStream<Buffer> {
    private static final int CHUNK_SIZE = 2048;
    private final VertxHttpRequest vertxHttpRequest;
    private final InputStream is;
    private final HttpClientRequest request;
    private InboundBuffer<Buffer> inboundBuffer;
    private Handler<Throwable> exceptionHandler;
    private Handler<Void> endHandler;
    private byte[] bytes;

    public InputStreamReadStream(VertxHttpRequest vertxHttpRequest, InputStream is, HttpClientRequest request) {
        this.vertxHttpRequest = vertxHttpRequest;
        this.is = is;
        this.request = request;
    }

    public ReadStream<Buffer> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ReadStream<Buffer> handler(Handler<Buffer> handler) {
        boolean start;
        boolean bl = start = this.inboundBuffer == null && handler != null;
        if (start) {
            this.inboundBuffer = new InboundBuffer(this.vertxHttpRequest.vertx.getOrCreateContext());
            this.inboundBuffer.drainHandler(v -> this.readChunk());
        }
        if (handler != null) {
            this.inboundBuffer.handler(buff -> {
                if (buff == null) {
                    if (this.endHandler != null) {
                        this.endHandler.handle(null);
                    }
                } else {
                    handler.handle(buff);
                }
            });
        } else {
            this.inboundBuffer.handler(null);
        }
        if (start) {
            this.readChunk();
        }
        return this;
    }

    private void readChunk() {
        Future fut = this.vertxHttpRequest.vertx.executeBlocking(p -> {
            int amount;
            if (this.bytes == null) {
                this.bytes = new byte[2048];
            }
            try {
                amount = this.is.read(this.bytes);
            }
            catch (IOException e) {
                p.fail((Throwable)e);
                return;
            }
            if (amount == -1) {
                p.complete();
            } else {
                p.complete((Object)Buffer.buffer((ByteBuf)VertxByteBufAllocator.DEFAULT.heapBuffer(amount, Integer.MAX_VALUE).writeBytes(this.bytes, 0, amount)));
            }
        });
        fut.onComplete(ar -> {
            if (ar.succeeded()) {
                Buffer chunk = (Buffer)ar.result();
                if (chunk != null) {
                    boolean writable = this.inboundBuffer.write((Object)chunk);
                    if (writable) {
                        this.readChunk();
                    }
                } else {
                    this.inboundBuffer.write((Object)null);
                }
            } else {
                if (this.exceptionHandler != null) {
                    this.exceptionHandler.handle((Object)ar.cause());
                }
                this.request.reset(0L, ar.cause());
            }
        });
    }

    public ReadStream<Buffer> endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    public ReadStream<Buffer> pause() {
        this.inboundBuffer.pause();
        return this;
    }

    public ReadStream<Buffer> resume() {
        this.inboundBuffer.resume();
        return this;
    }

    public ReadStream<Buffer> fetch(long amount) {
        this.inboundBuffer.fetch(amount);
        return this;
    }
}

