/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.vertx;

import io.fabric8.kubernetes.client.http.AsyncBody;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpResponse;
import io.fabric8.kubernetes.client.http.StandardHttpClient;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.StandardHttpRequest;
import io.fabric8.kubernetes.client.http.StandardWebSocketBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.http.WebSocketResponse;
import io.fabric8.kubernetes.client.vertx.VertxHttpRequest;
import io.fabric8.kubernetes.client.vertx.VertxWebSocket;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkSslContext;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpVersion;
import io.vertx.core.http.RequestOptions;
import io.vertx.core.http.UpgradeRejectedException;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.ProxyType;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.spi.tls.SslContextFactory;
import io.vertx.ext.web.client.WebClientOptions;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;

public class VertxHttpClientFactory
implements HttpClient.Factory {
    private static final int MAX_CONNECTIONS = 8192;
    private Vertx vertx = Vertx.vertx();

    public VertxHttpClientBuilder newBuilder() {
        return new VertxHttpClientBuilder(this);
    }

    private class VertxHttpClient
    extends StandardHttpClient<VertxHttpClient, VertxHttpClientFactory, VertxHttpClientBuilder> {
        private List<VertxHttpClient> derivedClients;
        private final HttpClient client;
        private final String proxyAuthorization;

        private VertxHttpClient(VertxHttpClientBuilder vertxHttpClientBuilder, WebClientOptions options, String proxyAuthorization) {
            super((StandardHttpClientBuilder)vertxHttpClientBuilder);
            this.derivedClients = Collections.synchronizedList(new ArrayList());
            this.client = VertxHttpClientFactory.this.vertx.createHttpClient((HttpClientOptions)options);
            this.proxyAuthorization = proxyAuthorization;
        }

        public CompletableFuture<WebSocketResponse> buildWebSocketDirect(StandardWebSocketBuilder standardWebSocketBuilder, WebSocket.Listener listener) {
            WebSocketConnectOptions options = new WebSocketConnectOptions();
            if (this.builder.getReadTimeout() != null) {
                options.setTimeout(this.builder.getReadTimeout().toMillis());
            }
            if (standardWebSocketBuilder.getSubprotocol() != null) {
                options.setSubProtocols(Collections.singletonList(standardWebSocketBuilder.getSubprotocol()));
            }
            StandardHttpRequest request = standardWebSocketBuilder.asHttpRequest();
            request.headers().entrySet().stream().forEach(e -> ((List)e.getValue()).stream().forEach(v -> options.addHeader((String)e.getKey(), v)));
            options.setAbsoluteURI(request.uri().toString());
            CompletableFuture<WebSocketResponse> response = new CompletableFuture<WebSocketResponse>();
            this.client.webSocket(options).onSuccess(ws -> {
                VertxWebSocket ret = new VertxWebSocket((WebSocket)ws, listener);
                ret.init();
                response.complete(new WebSocketResponse((io.fabric8.kubernetes.client.http.WebSocket)ret, null));
            }).onFailure(t -> {
                if (t instanceof UpgradeRejectedException) {
                    final UpgradeRejectedException handshake = (UpgradeRejectedException)t;
                    response.complete(new WebSocketResponse(null, new WebSocketHandshakeException((HttpResponse)new HttpResponse<String>(){

                        public int code() {
                            return handshake.getStatus();
                        }

                        public String body() {
                            return handshake.getBody().toString();
                        }

                        public HttpRequest request() {
                            throw new UnsupportedOperationException();
                        }

                        public Optional<HttpResponse<?>> previousResponse() {
                            return Optional.empty();
                        }

                        public List<String> headers(String s) {
                            return handshake.getHeaders().getAll(s);
                        }

                        public Map<String, List<String>> headers() {
                            LinkedHashMap<String, List<String>> headers = new LinkedHashMap<String, List<String>>();
                            handshake.getHeaders().names().forEach(name -> headers.put((String)name, handshake.getHeaders().getAll(name)));
                            return headers;
                        }
                    })));
                }
                response.completeExceptionally((Throwable)t);
            });
            return response;
        }

        public CompletableFuture<HttpResponse<AsyncBody>> consumeBytesDirect(StandardHttpRequest request, AsyncBody.Consumer<List<ByteBuffer>> consumer) {
            RequestOptions options = new RequestOptions();
            request.headers().forEach((k, l) -> l.forEach(v -> options.addHeader(k, v)));
            options.setAbsoluteURI(request.uri().toString());
            options.setMethod(HttpMethod.valueOf((String)request.method()));
            if (this.proxyAuthorization != null) {
                options.putHeader(HttpHeaders.PROXY_AUTHORIZATION, (CharSequence)this.proxyAuthorization);
            }
            Optional.ofNullable(request.getContentType()).ifPresent(s -> options.putHeader(HttpHeaders.CONTENT_TYPE, (CharSequence)s));
            if (request.isExpectContinue()) {
                options.putHeader(HttpHeaders.EXPECT, HttpHeaders.CONTINUE);
            }
            return new VertxHttpRequest(VertxHttpClientFactory.this.vertx, options, request.body()).consumeBytes(this.client, consumer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.client.close();
            List<VertxHttpClient> list = this.derivedClients;
            synchronized (list) {
                this.derivedClients.forEach(VertxHttpClient::close);
                this.derivedClients.clear();
            }
        }
    }

    private final class VertxHttpClientBuilder
    extends StandardHttpClientBuilder<VertxHttpClient, VertxHttpClientFactory, VertxHttpClientBuilder> {
        protected VertxHttpClientBuilder(VertxHttpClientFactory clientFactory) {
            super((HttpClient.Factory)clientFactory);
        }

        public VertxHttpClient build() {
            WebClientOptions options = new WebClientOptions();
            options.setMaxPoolSize(8192);
            options.setMaxWebSockets(8192);
            options.setIdleTimeoutUnit(TimeUnit.SECONDS);
            if (this.connectTimeout != null) {
                options.setConnectTimeout((int)this.connectTimeout.toMillis());
            }
            if (this.writeTimeout != null) {
                options.setWriteIdleTimeout((int)this.writeTimeout.getSeconds());
            }
            if (this.followRedirects) {
                options.setFollowRedirects(this.followRedirects);
            }
            if (this.proxyAddress != null) {
                ProxyOptions proxyOptions = new ProxyOptions().setHost(this.proxyAddress.getHostName()).setPort(this.proxyAddress.getPort()).setType(ProxyType.HTTP);
                options.setProxyOptions(proxyOptions);
            }
            if (this.tlsVersions != null && this.tlsVersions.length > 0) {
                Stream.of(this.tlsVersions).map(TlsVersion::javaName).forEach(tls -> options.addEnabledSecureTransportProtocol(tls));
            }
            if (this.preferHttp11) {
                options.setProtocolVersion(HttpVersion.HTTP_1_1);
            }
            if (this.sslContext != null) {
                options.setSsl(true);
                options.setSslEngineOptions((SSLEngineOptions)new JdkSSLEngineOptions(){

                    public JdkSSLEngineOptions copy() {
                        return this;
                    }

                    public SslContextFactory sslContextFactory() {
                        return () -> new JdkSslContext(VertxHttpClientBuilder.this.sslContext, true, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.NONE, null, false);
                    }
                });
            }
            VertxHttpClient result = new VertxHttpClient(this, options, this.proxyAddress != null ? this.proxyAuthorization : null);
            if (this.client != null) {
                ((VertxHttpClient)this.client).derivedClients.add(result);
            }
            return result;
        }

        protected VertxHttpClientBuilder newInstance(VertxHttpClientFactory clientFactory) {
            return new VertxHttpClientBuilder(clientFactory);
        }
    }
}

