/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientImpl;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.List;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;

class OkHttpRequestImpl
implements HttpRequest {
    private Request request;

    public OkHttpRequestImpl(Request request) {
        this.request = request;
    }

    public URI uri() {
        return this.request.url().uri();
    }

    public String method() {
        return this.request.method();
    }

    public Request getRequest() {
        return this.request;
    }

    public List<String> headers(String key) {
        return this.request.headers(key);
    }

    public Map<String, List<String>> headers() {
        return this.request.headers().toMultimap();
    }

    public String bodyString() {
        if (this.request.body() == null) {
            return null;
        }
        Buffer buffer = new Buffer();
        try {
            this.request.body().writeTo((BufferedSink)buffer);
        }
        catch (IOException e) {
            return null;
        }
        return buffer.readUtf8();
    }

    static class BuilderImpl
    implements HttpRequest.Builder {
        private final Request.Builder builder;

        public BuilderImpl(Request.Builder builder) {
            this.builder = builder;
        }

        public HttpRequest build() {
            return new OkHttpRequestImpl(this.builder.build());
        }

        public HttpRequest.Builder uri(String uri) {
            this.builder.url(uri);
            return this;
        }

        public HttpRequest.Builder url(URL resourceUrl) {
            this.builder.url(resourceUrl);
            return this;
        }

        public HttpRequest.Builder method(String method, String contentType, String body) {
            this.builder.method(method, RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (String)body));
            return this;
        }

        public HttpRequest.Builder post(String contentType, byte[] writeValueAsBytes) {
            this.builder.post(RequestBody.create((MediaType)OkHttpClientImpl.parseMediaType(contentType), (byte[])writeValueAsBytes));
            return this;
        }

        public HttpRequest.Builder post(final String contentType, final InputStream inputStream, final long length) {
            this.builder.post(new RequestBody(){

                public void writeTo(BufferedSink sink) throws IOException {
                    try (BufferedInputStream bis = new BufferedInputStream(inputStream);
                         Source source = Okio.source((InputStream)bis);){
                        sink.writeAll(source);
                    }
                }

                public MediaType contentType() {
                    return OkHttpClientImpl.parseMediaType(contentType);
                }

                public long contentLength() throws IOException {
                    return length;
                }
            });
            return this;
        }

        public HttpRequest.Builder header(String k, String v) {
            this.builder.addHeader(k, v);
            return this;
        }

        public HttpRequest.Builder setHeader(String k, String v) {
            this.builder.header(k, v);
            return this;
        }

        public HttpRequest.Builder uri(URI uri) {
            try {
                this.builder.url(uri.toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(uri.toString(), e);
            }
            return this;
        }

        public HttpRequest.Builder expectContinue() {
            this.builder.header("Expect", "100-continue");
            return this;
        }
    }
}

