/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.StandardHttpClientBuilder;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientImpl;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.util.Arrays;
import javax.net.ssl.SSLParameters;

class JdkHttpClientBuilderImpl
extends StandardHttpClientBuilder<JdkHttpClientImpl, JdkHttpClientFactory, JdkHttpClientBuilderImpl> {
    public JdkHttpClientBuilderImpl(JdkHttpClientFactory factory) {
        super((HttpClient.Factory)factory);
    }

    public HttpClient build() {
        if (this.client != null) {
            return new JdkHttpClientImpl(this, ((JdkHttpClientImpl)this.client).getHttpClient(), this.requestConfig);
        }
        HttpClient.Builder builder = ((JdkHttpClientFactory)this.clientFactory).createNewHttpClientBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.sslContext != null) {
            builder.sslContext(this.sslContext);
        }
        if (this.followRedirects) {
            builder.followRedirects(HttpClient.Redirect.ALWAYS);
        }
        if (this.proxyAddress != null) {
            builder.proxy(ProxySelector.of(this.proxyAddress));
        } else {
            builder.proxy(HttpClient.Builder.NO_PROXY);
        }
        if (this.proxyAuthorization != null) {
            this.interceptors.put("PROXY-AUTH", new Interceptor(){

                public void before(BasicBuilder builder, HttpHeaders headers) {
                    builder.setHeader("Proxy-Authorization", JdkHttpClientBuilderImpl.this.proxyAuthorization);
                }
            });
        }
        if (this.preferHttp11) {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            builder.sslParameters(new SSLParameters(null, (String[])Arrays.asList(this.tlsVersions).stream().map(TlsVersion::javaName).toArray(String[]::new)));
        }
        ((JdkHttpClientFactory)this.clientFactory).additionalConfig(builder);
        return new JdkHttpClientImpl(this, builder.build(), null);
    }

    protected JdkHttpClientBuilderImpl newInstance(JdkHttpClientFactory clientFactory) {
        return new JdkHttpClientBuilderImpl(clientFactory);
    }
}

