/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.http.WebSocketHandshakeException;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpRequestImpl;
import io.fabric8.kubernetes.client.jdkhttp.JdkWebSocketImpl;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpResponse;
import java.net.http.WebSocket;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;

public class JdkHttpClientImpl
implements HttpClient {
    private JdkHttpClientBuilderImpl builder;
    private java.net.http.HttpClient httpClient;

    public JdkHttpClientImpl(JdkHttpClientBuilderImpl builderImpl, java.net.http.HttpClient httpClient) {
        this.builder = builderImpl;
        this.httpClient = httpClient;
    }

    public void close() {
        if (this.httpClient == null) {
            return;
        }
        this.builder.clientFactory.closeHttpClient(this);
        this.httpClient = null;
    }

    public HttpClient.DerivedClientBuilder newBuilder() {
        return this.builder.copy(this.getHttpClient());
    }

    public CompletableFuture<io.fabric8.kubernetes.client.http.HttpResponse<HttpClient.AsyncBody>> consumeLines(HttpRequest request, HttpClient.BodyConsumer<String> consumer) {
        return this.sendAsync(request, () -> {
            AsyncBodySubscriber subscriber = new AsyncBodySubscriber(consumer);
            HttpResponse.BodyHandler<Void> handler = HttpResponse.BodyHandlers.fromLineSubscriber(subscriber);
            return new HandlerAndAsyncBody<Void>(handler, subscriber);
        }).thenApply(r -> new JdkHttpResponseImpl<HttpClient.AsyncBody>(r.response, r.asyncBody));
    }

    public CompletableFuture<io.fabric8.kubernetes.client.http.HttpResponse<HttpClient.AsyncBody>> consumeBytes(HttpRequest request, HttpClient.BodyConsumer<List<ByteBuffer>> consumer) {
        return this.sendAsync(request, () -> {
            AsyncBodySubscriber subscriber = new AsyncBodySubscriber(consumer);
            HttpResponse.BodyHandler<Void> handler = HttpResponse.BodyHandlers.fromSubscriber(subscriber);
            return new HandlerAndAsyncBody<Void>(handler, subscriber);
        }).thenApply(r -> new JdkHttpResponseImpl<HttpClient.AsyncBody>(r.response, r.asyncBody));
    }

    public <T> CompletableFuture<io.fabric8.kubernetes.client.http.HttpResponse<T>> sendAsync(HttpRequest request, Class<T> type) {
        return this.sendAsync(request, () -> new HandlerAndAsyncBody(this.toBodyHandler(type), null)).thenApply(ar -> new JdkHttpResponseImpl(ar.response));
    }

    private <T> HttpResponse.BodyHandler<T> toBodyHandler(Class<T> type) {
        HttpResponse.BodyHandler<Object> bodyHandler = type == null ? HttpResponse.BodyHandlers.discarding() : (type == InputStream.class ? HttpResponse.BodyHandlers.ofInputStream() : (type == String.class ? HttpResponse.BodyHandlers.ofString() : (type == byte[].class ? HttpResponse.BodyHandlers.ofByteArray() : responseInfo -> {
            HttpResponse.BodySubscriber<InputStream> upstream = HttpResponse.BodyHandlers.ofInputStream().apply(responseInfo);
            HttpResponse.BodySubscriber<Reader> downstream = HttpResponse.BodySubscribers.mapping(upstream, is -> new InputStreamReader((InputStream)is, StandardCharsets.UTF_8));
            return downstream;
        })));
        return bodyHandler;
    }

    public <T> CompletableFuture<AsyncResponse<T>> sendAsync(HttpRequest request, Supplier<HandlerAndAsyncBody<T>> handlerAndAsyncBodySupplier) {
        JdkHttpRequestImpl jdkRequest = (JdkHttpRequestImpl)request;
        JdkHttpRequestImpl.BuilderImpl builderImpl = jdkRequest.newBuilder();
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            interceptor.before((BasicBuilder)builderImpl, (HttpHeaders)jdkRequest);
            jdkRequest = builderImpl.build();
        }
        HandlerAndAsyncBody<T> handlerAndAsyncBody = handlerAndAsyncBodySupplier.get();
        CompletionStage cf = this.getHttpClient().sendAsync(builderImpl.build().request, handlerAndAsyncBody.handler).thenApply(r -> new AsyncResponse(r, handlerAndAsyncBody.asyncBody));
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            cf = ((CompletableFuture)cf).thenCompose(ar -> {
                HttpResponse response = ar.response;
                if (response != null && !io.fabric8.kubernetes.client.http.HttpResponse.isSuccessful((int)response.statusCode())) {
                    return interceptor.afterFailure((HttpRequest.Builder)builderImpl, new JdkHttpResponseImpl(response)).thenCompose(arg_0 -> this.lambda$sendAsync$10((Supplier)handlerAndAsyncBodySupplier, builderImpl, ar, arg_0));
                }
                return CompletableFuture.completedFuture(ar);
            });
        }
        return cf;
    }

    public WebSocket.Builder newWebSocketBuilder() {
        return new JdkWebSocketImpl.BuilderImpl(this);
    }

    public HttpRequest.Builder newHttpRequestBuilder() {
        return new JdkHttpRequestImpl.BuilderImpl().timeout(this.builder.readTimeout);
    }

    public CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket> buildAsync(JdkWebSocketImpl.BuilderImpl webSocketBuilder, WebSocket.Listener listener) {
        JdkWebSocketImpl.BuilderImpl copy = webSocketBuilder.copy();
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            interceptor.before((BasicBuilder)copy, (HttpHeaders)new JdkHttpRequestImpl(null, copy.asRequest()));
        }
        CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket> result = new CompletableFuture<io.fabric8.kubernetes.client.http.WebSocket>();
        CompletionStage<WebSocketResponse> cf = this.internalBuildAsync(copy, listener);
        for (Interceptor interceptor : this.builder.interceptors.values()) {
            cf = cf.thenCompose(response -> {
                if (response.wshse != null && response.wshse.getResponse() != null) {
                    return interceptor.afterFailure((BasicBuilder)copy, new JdkHttpResponseImpl(response.wshse.getResponse())).thenCompose(b -> {
                        if (b.booleanValue()) {
                            return this.internalBuildAsync(copy, listener);
                        }
                        return CompletableFuture.completedFuture(response);
                    });
                }
                return CompletableFuture.completedFuture(response);
            });
        }
        cf.whenComplete((r, t) -> {
            if (t != null) {
                result.completeExceptionally((Throwable)t);
            } else if (r != null) {
                if (r.wshse != null) {
                    result.completeExceptionally((Throwable)new WebSocketHandshakeException(new JdkHttpResponseImpl(r.wshse.getResponse())).initCause((Throwable)r.wshse));
                } else {
                    result.complete(r.webSocket);
                }
            } else {
                result.complete(null);
            }
        });
        return result;
    }

    public CompletableFuture<WebSocketResponse> internalBuildAsync(JdkWebSocketImpl.BuilderImpl webSocketBuilder, WebSocket.Listener listener) {
        java.net.http.HttpRequest request = webSocketBuilder.asRequest();
        WebSocket.Builder newBuilder = this.getHttpClient().newWebSocketBuilder();
        request.headers().map().forEach((k, v) -> v.forEach(s -> newBuilder.header((String)k, (String)s)));
        if (webSocketBuilder.subprotocol != null) {
            newBuilder.subprotocols(webSocketBuilder.subprotocol, new String[0]);
        }
        if (this.builder.readTimeout != null) {
            newBuilder.connectTimeout(this.builder.readTimeout);
        }
        AtomicLong queueSize = new AtomicLong();
        CompletableFuture<WebSocketResponse> response = new CompletableFuture<WebSocketResponse>();
        URI uri = io.fabric8.kubernetes.client.http.WebSocket.toWebSocketUri((URI)request.uri());
        newBuilder.buildAsync(uri, new JdkWebSocketImpl.ListenerAdapter(listener, queueSize)).whenComplete((w, t) -> {
            if (t instanceof CompletionException && t.getCause() != null) {
                t = t.getCause();
            }
            if (t instanceof java.net.http.WebSocketHandshakeException) {
                response.complete(new WebSocketResponse(new JdkWebSocketImpl(queueSize, (WebSocket)w), (java.net.http.WebSocketHandshakeException)t));
            } else if (t != null) {
                response.completeExceptionally((Throwable)t);
            } else {
                response.complete(new WebSocketResponse(new JdkWebSocketImpl(queueSize, (WebSocket)w), null));
            }
        });
        return response;
    }

    public JdkHttpClientBuilderImpl getBuilder() {
        return this.builder;
    }

    java.net.http.HttpClient getHttpClient() {
        if (this.httpClient == null) {
            throw new IllegalStateException("Client already closed");
        }
        return this.httpClient;
    }

    public HttpClient.Factory getFactory() {
        return this.builder.clientFactory;
    }

    private /* synthetic */ CompletionStage lambda$sendAsync$10(Supplier handlerAndAsyncBodySupplier, JdkHttpRequestImpl.BuilderImpl builderImpl, AsyncResponse ar, Boolean b) {
        if (b.booleanValue()) {
            HandlerAndAsyncBody interceptedHandlerAndAsyncBody = (HandlerAndAsyncBody)handlerAndAsyncBodySupplier.get();
            return this.getHttpClient().sendAsync(builderImpl.build().request, interceptedHandlerAndAsyncBody.handler).thenApply(r -> new AsyncResponse(r, interceptedHandlerAndAsyncBody.asyncBody));
        }
        return CompletableFuture.completedFuture(ar);
    }

    private static class WebSocketResponse {
        io.fabric8.kubernetes.client.http.WebSocket webSocket;
        java.net.http.WebSocketHandshakeException wshse;

        public WebSocketResponse(io.fabric8.kubernetes.client.http.WebSocket w, java.net.http.WebSocketHandshakeException wshse) {
            this.webSocket = w;
            this.wshse = wshse;
        }
    }

    static class HandlerAndAsyncBody<T> {
        HttpResponse.BodyHandler<T> handler;
        HttpClient.AsyncBody asyncBody;

        public HandlerAndAsyncBody(HttpResponse.BodyHandler<T> handler, HttpClient.AsyncBody asyncBody) {
            this.handler = handler;
            this.asyncBody = asyncBody;
        }
    }

    static class AsyncResponse<T> {
        HttpResponse<T> response;
        HttpClient.AsyncBody asyncBody;

        public AsyncResponse(HttpResponse<T> response, HttpClient.AsyncBody asyncBody) {
            this.response = response;
            this.asyncBody = asyncBody;
        }
    }

    private static class JdkHttpResponseImpl<T>
    implements io.fabric8.kubernetes.client.http.HttpResponse<T> {
        private HttpResponse<?> response;
        private T body;

        public JdkHttpResponseImpl(HttpResponse<T> response) {
            this(response, response.body());
        }

        public JdkHttpResponseImpl(HttpResponse<?> response, T body) {
            this.response = response;
            this.body = body;
        }

        public List<String> headers(String key) {
            return this.response.headers().allValues(key);
        }

        public Map<String, List<String>> headers() {
            return this.response.headers().map();
        }

        public int code() {
            return this.response.statusCode();
        }

        public T body() {
            return this.body;
        }

        public HttpRequest request() {
            return new JdkHttpRequestImpl(null, this.response.request());
        }

        public Optional<io.fabric8.kubernetes.client.http.HttpResponse<?>> previousResponse() {
            return this.response.previousResponse().map(JdkHttpResponseImpl::new);
        }
    }

    private final class AsyncBodySubscriber<T>
    implements Flow.Subscriber<T>,
    HttpClient.AsyncBody {
        private final HttpClient.BodyConsumer<T> consumer;
        private CompletableFuture<Void> done = new CompletableFuture();
        private final AtomicBoolean subscribed = new AtomicBoolean();
        private volatile Flow.Subscription subscription;
        private T initialItem;
        private boolean first = true;
        private boolean isComplete;

        private AsyncBodySubscriber(HttpClient.BodyConsumer<T> consumer) {
            this.consumer = consumer;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (!this.subscribed.compareAndSet(false, true)) {
                subscription.cancel();
                return;
            }
            this.subscription = subscription;
            subscription.request(1L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T item) {
            AsyncBodySubscriber asyncBodySubscriber = this;
            synchronized (asyncBodySubscriber) {
                if (this.first) {
                    this.initialItem = item;
                    this.first = false;
                    return;
                }
            }
            try {
                if (item == null) {
                    this.done.complete(null);
                } else {
                    this.consumer.consume(item, (HttpClient.AsyncBody)this);
                }
            }
            catch (Exception e) {
                this.subscription.cancel();
                this.done.completeExceptionally(e);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.done.completeExceptionally(throwable);
        }

        @Override
        public synchronized void onComplete() {
            if (this.initialItem != null) {
                this.isComplete = true;
                return;
            }
            this.done.complete(null);
        }

        public synchronized void consume() {
            if (this.done.isDone()) {
                return;
            }
            try {
                this.first = false;
                if (this.initialItem != null) {
                    T item = this.initialItem;
                    this.initialItem = null;
                    this.onNext(item);
                }
            }
            finally {
                if (this.isComplete) {
                    this.done.complete(null);
                }
                this.subscription.request(1L);
            }
        }

        public CompletableFuture<Void> done() {
            return this.done;
        }

        public void cancel() {
            this.subscription.cancel();
            this.done.cancel(false);
        }
    }
}

