/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.jdkhttp;

import io.fabric8.kubernetes.client.http.BasicBuilder;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.Interceptor;
import io.fabric8.kubernetes.client.http.TlsVersion;
import io.fabric8.kubernetes.client.internal.SSLUtils;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientFactory;
import io.fabric8.kubernetes.client.jdkhttp.JdkHttpClientImpl;
import java.net.InetSocketAddress;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManager;

class JdkHttpClientBuilderImpl
implements HttpClient.Builder {
    LinkedHashMap<String, Interceptor> interceptors = new LinkedHashMap();
    Duration connectTimeout;
    Duration readTimeout;
    private SSLContext sslContext;
    JdkHttpClientFactory clientFactory;
    private String proxyAuthorization;
    private InetSocketAddress proxyAddress;
    private boolean followRedirects;
    private boolean preferHttp11;
    private TlsVersion[] tlsVersions;
    private HttpClient httpClient;

    JdkHttpClientBuilderImpl(JdkHttpClientFactory factory) {
        this.clientFactory = factory;
    }

    public io.fabric8.kubernetes.client.http.HttpClient build() {
        if (this.httpClient != null) {
            return new JdkHttpClientImpl(this, this.httpClient);
        }
        HttpClient.Builder builder = this.clientFactory.createNewHttpClientBuilder();
        if (this.connectTimeout != null) {
            builder.connectTimeout(this.connectTimeout);
        }
        if (this.sslContext != null) {
            builder.sslContext(this.sslContext);
        }
        if (this.followRedirects) {
            builder.followRedirects(HttpClient.Redirect.ALWAYS);
        }
        if (this.proxyAddress != null) {
            builder.proxy(ProxySelector.of(this.proxyAddress));
        } else {
            builder.proxy(HttpClient.Builder.NO_PROXY);
        }
        if (this.proxyAuthorization != null) {
            this.interceptors.put("PROXY-AUTH", new Interceptor(){

                public void before(BasicBuilder builder, HttpHeaders headers) {
                    builder.setHeader("Proxy-Authorization", JdkHttpClientBuilderImpl.this.proxyAuthorization);
                }
            });
        }
        if (this.preferHttp11) {
            builder.version(HttpClient.Version.HTTP_1_1);
        }
        if (this.tlsVersions != null && this.tlsVersions.length > 0) {
            builder.sslParameters(new SSLParameters(null, (String[])Arrays.asList(this.tlsVersions).stream().map(TlsVersion::javaName).toArray(String[]::new)));
        }
        this.clientFactory.additionalConfig(builder);
        return new JdkHttpClientImpl(this, builder.build());
    }

    public JdkHttpClientBuilderImpl readTimeout(long readTimeout, TimeUnit unit) {
        this.readTimeout = readTimeout == 0L ? null : Duration.ofNanos(unit.toNanos(readTimeout));
        return this;
    }

    public HttpClient.Builder connectTimeout(long connectTimeout, TimeUnit unit) {
        this.connectTimeout = Duration.ofNanos(unit.toNanos(connectTimeout));
        return this;
    }

    public HttpClient.Builder forStreaming() {
        return this;
    }

    public HttpClient.Builder writeTimeout(long timeout, TimeUnit timeoutUnit) {
        return this;
    }

    public HttpClient.Builder addOrReplaceInterceptor(String name, Interceptor interceptor) {
        if (interceptor == null) {
            this.interceptors.remove(name);
        } else {
            this.interceptors.put(name, interceptor);
        }
        return this;
    }

    public HttpClient.Builder authenticatorNone() {
        return this;
    }

    public HttpClient.Builder sslContext(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        this.sslContext = SSLUtils.sslContext((KeyManager[])keyManagers, (TrustManager[])trustManagers);
        return this;
    }

    public HttpClient.Builder followAllRedirects() {
        this.followRedirects = true;
        return this;
    }

    public HttpClient.Builder proxyAddress(InetSocketAddress proxyAddress) {
        this.proxyAddress = proxyAddress;
        return this;
    }

    public HttpClient.Builder proxyAuthorization(String credentials) {
        this.proxyAuthorization = credentials;
        return this;
    }

    public HttpClient.Builder preferHttp11() {
        this.preferHttp11 = true;
        return this;
    }

    public HttpClient.Builder tlsVersions(TlsVersion ... tlsVersions) {
        this.tlsVersions = tlsVersions;
        return this;
    }

    public JdkHttpClientBuilderImpl copy(HttpClient httpClient) {
        JdkHttpClientBuilderImpl copy = new JdkHttpClientBuilderImpl(this.clientFactory);
        copy.connectTimeout = this.connectTimeout;
        copy.readTimeout = this.readTimeout;
        copy.sslContext = this.sslContext;
        copy.interceptors = new LinkedHashMap<String, Interceptor>(this.interceptors);
        copy.proxyAddress = this.proxyAddress;
        copy.proxyAuthorization = this.proxyAuthorization;
        copy.tlsVersions = this.tlsVersions;
        copy.preferHttp11 = this.preferHttp11;
        copy.followRedirects = this.followRedirects;
        copy.httpClient = httpClient;
        return copy;
    }
}

